/*
 * Decompiled with CFR 0.152.
 */
package openmods;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import openmods.LibConfig;
import openmods.config.properties.CommandConfig;
import openmods.config.properties.ConfigProcessing;
import openmods.entity.DelayedEntityLoadManager;
import openmods.events.network.TileEntityEventHandler;
import openmods.events.network.TileEntityMessageEventPacket;
import openmods.fakeplayer.FakePlayerPool;
import openmods.integration.Integration;
import openmods.integration.modules.BuildCraftPipes;
import openmods.network.IdSyncManager;
import openmods.network.event.NetworkEventManager;
import openmods.network.rpc.RpcCallDispatcher;
import openmods.network.rpc.targets.EntityRpcTarget;
import openmods.network.rpc.targets.SyncRpcTarget;
import openmods.network.rpc.targets.TileEntityRpcTarget;
import openmods.proxy.IOpenModsProxy;
import openmods.sync.SyncChannelHolder;
import openmods.utils.bitmap.IRpcDirectionBitMap;
import openmods.utils.bitmap.IRpcIntBitMap;
import openmods.world.DelayedActionTickHandler;

@Mod(modid="OpenMods", name="OpenMods", version="0.6", dependencies="required-after:OpenModsCore")
public class OpenMods {
    @Mod.Instance(value="OpenMods")
    public static OpenMods instance;
    @SidedProxy(clientSide="openmods.proxy.OpenClientProxy", serverSide="openmods.proxy.OpenServerProxy")
    public static IOpenModsProxy proxy;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        SyncChannelHolder.ensureLoaded();
        NetworkEventManager.INSTANCE.startRegistration().register(TileEntityMessageEventPacket.class);
        RpcCallDispatcher.INSTANCE.startRegistration().registerInterface(IRpcDirectionBitMap.class).registerInterface(IRpcIntBitMap.class).registerTargetWrapper(EntityRpcTarget.class).registerTargetWrapper(TileEntityRpcTarget.class).registerTargetWrapper(SyncRpcTarget.SyncEntityRpcTarget.class).registerTargetWrapper(SyncRpcTarget.SyncTileEntityRpcTarget.class);
        File configFile = evt.getSuggestedConfigurationFile();
        Configuration config = new Configuration(configFile);
        ConfigProcessing.processAnnotations(configFile, "OpenMods", config, LibConfig.class);
        if (config.hasChanged()) {
            config.save();
        }
        MinecraftForge.EVENT_BUS.register((Object)new TileEntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)DelayedEntityLoadManager.instance);
        MinecraftForge.EVENT_BUS.register((Object)FakePlayerPool.instance);
        FMLCommonHandler.instance().bus().register((Object)DelayedActionTickHandler.INSTANCE);
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        Integration.addModule(new BuildCraftPipes());
        Integration.loadModules();
        proxy.postInit();
        NetworkEventManager.INSTANCE.finalizeRegistration();
        RpcCallDispatcher.INSTANCE.finishRegistration();
        IdSyncManager.INSTANCE.finishLoading();
    }

    @Mod.EventHandler
    public void severStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandConfig("om_config_s", true));
    }
}

