/*
 * Decompiled with CFR 0.152.
 */
package openmods.asm;

import cpw.mods.fml.common.asm.transformers.deobf.FMLDeobfuscatingRemapper;
import openmods.asm.MappedType;
import openmods.asm.VisitorHelper;

public class MethodMatcher {
    private final String clsName;
    private final String description;
    private final String srgName;
    private final String mcpName;

    public MethodMatcher(String clsName, String description, String mcpName, String srgName) {
        this.clsName = clsName;
        this.description = description;
        this.srgName = srgName;
        this.mcpName = mcpName;
    }

    public MethodMatcher(MappedType cls, String description, String mcpName, String srgName) {
        this(cls.name(), description, mcpName, srgName);
    }

    public boolean match(String methodName, String methodDesc) {
        if (!methodDesc.equals(this.description)) {
            return false;
        }
        if (methodName.equals(this.mcpName)) {
            return true;
        }
        if (!VisitorHelper.useSrgNames()) {
            return false;
        }
        String mapped = FMLDeobfuscatingRemapper.INSTANCE.mapMethodName(this.clsName, methodName, methodDesc);
        return mapped.equals(this.srgName);
    }
}

