/*
 * Decompiled with CFR 0.152.
 */
package openmods.events.network;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import openmods.network.DimCoord;
import openmods.network.event.NetworkEvent;
import openmods.network.event.NetworkEventManager;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.WorldUtils;

public class TileEntityMessageEventPacket
extends NetworkEvent {
    public int dimension;
    public int xCoord;
    public int yCoord;
    public int zCoord;

    public TileEntityMessageEventPacket() {
    }

    public TileEntityMessageEventPacket(OpenTileEntity tile) {
        this.dimension = tile.func_145831_w().field_73011_w.field_76574_g;
        this.xCoord = tile.field_145851_c;
        this.yCoord = tile.field_145848_d;
        this.zCoord = tile.field_145849_e;
    }

    @Override
    protected final void readFromStream(DataInput input) throws IOException {
        this.dimension = input.readInt();
        this.xCoord = input.readInt();
        this.yCoord = input.readInt();
        this.zCoord = input.readInt();
        this.readPayload(input);
    }

    protected void readPayload(DataInput input) {
    }

    @Override
    protected final void writeToStream(DataOutput output) throws IOException {
        output.writeInt(this.dimension);
        output.writeInt(this.xCoord);
        output.writeInt(this.yCoord);
        output.writeInt(this.zCoord);
        this.writePayload(output);
    }

    protected void writePayload(DataOutput output) {
    }

    @Override
    protected void appendLogInfo(List<String> info) {
        info.add(String.format("%d,%d,%d", this.xCoord, this.yCoord, this.zCoord));
    }

    public OpenTileEntity getTileEntity() {
        World world = WorldUtils.getWorld(this.dimension);
        TileEntity te = world.func_147438_o(this.xCoord, this.yCoord, this.zCoord);
        return te instanceof OpenTileEntity ? (OpenTileEntity)te : null;
    }

    public void sendToWatchers() {
        NetworkEventManager.INSTANCE.dispatcher().sendToBlockWatchers(this, this.getDimCoords());
    }

    public DimCoord getDimCoords() {
        return new DimCoord(this.dimension, this.xCoord, this.yCoord, this.zCoord);
    }
}

