/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import openmods.gui.component.GuiComponentSprite;
import org.lwjgl.opengl.GL11;

public class GuiComponentCraftingGrid
extends GuiComponentSprite {
    protected static RenderItem itemRenderer = new RenderItem();
    private ItemStack[] items;

    public GuiComponentCraftingGrid(int x, int y, ItemStack[] items, IIcon icon, ResourceLocation texture) {
        super(x, y, icon, texture);
        this.items = items;
    }

    @Override
    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        super.renderOverlay(minecraft, offsetX, offsetY, mouseX, mouseY);
        int relativeMouseX = mouseX + offsetX - this.x;
        int relativeMouseY = mouseY + offsetY - this.y;
        int gridOffsetX = 1;
        int gridOffsetY = 1;
        int itemBoxSize = 19;
        ItemStack tooltip = null;
        for (int i = 0; i < this.items.length; ++i) {
            ItemStack input = this.items[i];
            if (input == null) continue;
            int row = i % 3;
            int column = i / 3;
            int itemX = offsetX + gridOffsetX + row * itemBoxSize;
            int itemY = offsetY + gridOffsetY + column * itemBoxSize;
            this.drawItemStack(input, this.x + itemX, this.y + itemY, "");
            if (relativeMouseX <= itemX - 2 || relativeMouseX >= itemX - 2 + itemBoxSize || relativeMouseY <= itemY - 2 || relativeMouseY >= itemY - 2 + itemBoxSize) continue;
            tooltip = input;
        }
        if (tooltip != null) {
            this.drawItemStackTooltip(tooltip, relativeMouseX + 25, relativeMouseY + 30);
        }
    }

    protected void drawItemStackTooltip(ItemStack stack, int x, int y) {
        Minecraft mc = Minecraft.func_71410_x();
        FontRenderer font = (FontRenderer)Objects.firstNonNull((Object)stack.func_77973_b().getFontRenderer(stack), (Object)mc.field_71466_p);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        List list = stack.func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
        ArrayList colored = Lists.newArrayListWithCapacity((int)list.size());
        Iterator it = list.iterator();
        colored.add(GuiComponentCraftingGrid.getRarityColor(stack) + (String)it.next());
        while (it.hasNext()) {
            colored.add(EnumChatFormatting.GRAY + (String)it.next());
        }
        this.drawHoveringText(colored, x, y, font);
    }

    private static EnumChatFormatting getRarityColor(ItemStack stack) {
        return stack.func_77953_t().field_77937_e;
    }

    private void drawItemStack(ItemStack stack, int x, int y, String overlayText) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        this.field_73735_i = 200.0f;
        GuiComponentCraftingGrid.itemRenderer.field_77023_b = 200.0f;
        RenderHelper.func_74520_c();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnable((int)2977);
        FontRenderer font = null;
        if (stack != null) {
            font = stack.func_77973_b().getFontRenderer(stack);
        }
        if (font == null) {
            font = Minecraft.func_71410_x().field_71466_p;
        }
        itemRenderer.func_82406_b(font, Minecraft.func_71410_x().func_110434_K(), stack, x, y);
        itemRenderer.func_94148_a(font, Minecraft.func_71410_x().func_110434_K(), stack, x, y, overlayText);
        this.field_73735_i = 0.0f;
        GuiComponentCraftingGrid.itemRenderer.field_77023_b = 0.0f;
    }
}

