/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component;

import java.util.EnumSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.api.IValueReceiver;
import openmods.gui.component.BaseComponent;
import openmods.gui.listener.IListenerBase;
import openmods.gui.misc.SidePicker;
import openmods.gui.misc.Trackball;
import openmods.utils.MathUtils;
import openmods.utils.bitmap.IReadableBitMap;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiComponentSideSelector
extends BaseComponent
implements IValueReceiver<Set<ForgeDirection>> {
    private final RenderBlocks blockRender = new RenderBlocks();
    private final Trackball.TrackballWrapper trackball = new Trackball.TrackballWrapper(1, 40);
    public double scale;
    private ForgeDirection lastSideHovered;
    private final Set<ForgeDirection> selectedSides = EnumSet.noneOf(ForgeDirection.class);
    private boolean highlightSelectedSides = true;
    private int ticksSinceLastMouseEvent;
    private boolean isInitialized;
    private ISideSelectedListener sideSelectedListener;
    private Block block;
    private int meta;
    private TileEntity te;

    public GuiComponentSideSelector(int x, int y, double scale, Block block, int meta, TileEntity te, boolean highlightSelectedSides) {
        super(x, y);
        this.scale = scale;
        this.block = block;
        this.meta = meta;
        this.te = te;
        this.highlightSelectedSides = highlightSelectedSides;
    }

    @Override
    public void render(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
        SidePicker picker;
        SidePicker.HitCoord coord;
        ++this.ticksSinceLastMouseEvent;
        if (!this.isInitialized || Mouse.isButtonDown((int)2)) {
            this.trackball.setTransform(MathUtils.createEntityRotateMatrix((Entity)minecraft.field_71451_h));
            this.isInitialized = true;
        }
        GL11.glPushMatrix();
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glTranslated((double)((double)(offsetX + this.x) + this.scale / 2.0), (double)((double)(offsetY + this.y) + this.scale / 2.0), (double)this.scale);
        GL11.glScaled((double)this.scale, (double)(-this.scale), (double)this.scale);
        this.trackball.update(mouseX - this.getWidth(), -(mouseY - this.getHeight()));
        if (this.te != null) {
            TileEntityRendererDispatcher.field_147556_a.func_147549_a(this.te, -0.5, -0.5, -0.5, 0.0f);
        }
        if (this.block != null) {
            this.drawBlock(minecraft.field_71446_o, tessellator);
        }
        if ((coord = (picker = new SidePicker(0.5)).getNearestHit()) != null) {
            GuiComponentSideSelector.drawHighlight(tessellator, coord.side, 0x444444);
        }
        if (this.highlightSelectedSides) {
            for (ForgeDirection dir : this.selectedSides) {
                GuiComponentSideSelector.drawHighlight(tessellator, SidePicker.Side.fromForgeDirection(dir), 0xCC0000);
            }
        }
        this.lastSideHovered = coord == null ? ForgeDirection.UNKNOWN : coord.side.toForgeDirection();
        GL11.glPopMatrix();
    }

    @Override
    public void renderOverlay(Minecraft minecraft, int offsetX, int offsetY, int mouseX, int mouseY) {
    }

    private static void drawHighlight(Tessellator t, SidePicker.Side side, int color) {
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glBlendFunc((int)770, (int)771);
        t.func_78382_b();
        t.func_78384_a(color, 64);
        switch (side) {
            case XPos: {
                t.func_78377_a(0.5, -0.5, -0.5);
                t.func_78377_a(0.5, 0.5, -0.5);
                t.func_78377_a(0.5, 0.5, 0.5);
                t.func_78377_a(0.5, -0.5, 0.5);
                break;
            }
            case YPos: {
                t.func_78377_a(-0.5, 0.5, -0.5);
                t.func_78377_a(-0.5, 0.5, 0.5);
                t.func_78377_a(0.5, 0.5, 0.5);
                t.func_78377_a(0.5, 0.5, -0.5);
                break;
            }
            case ZPos: {
                t.func_78377_a(-0.5, -0.5, 0.5);
                t.func_78377_a(0.5, -0.5, 0.5);
                t.func_78377_a(0.5, 0.5, 0.5);
                t.func_78377_a(-0.5, 0.5, 0.5);
                break;
            }
            case XNeg: {
                t.func_78377_a(-0.5, -0.5, -0.5);
                t.func_78377_a(-0.5, -0.5, 0.5);
                t.func_78377_a(-0.5, 0.5, 0.5);
                t.func_78377_a(-0.5, 0.5, -0.5);
                break;
            }
            case YNeg: {
                t.func_78377_a(-0.5, -0.5, -0.5);
                t.func_78377_a(0.5, -0.5, -0.5);
                t.func_78377_a(0.5, -0.5, 0.5);
                t.func_78377_a(-0.5, -0.5, 0.5);
                break;
            }
            case ZNeg: {
                t.func_78377_a(-0.5, -0.5, -0.5);
                t.func_78377_a(-0.5, 0.5, -0.5);
                t.func_78377_a(0.5, 0.5, -0.5);
                t.func_78377_a(0.5, -0.5, -0.5);
                break;
            }
        }
        t.func_78381_a();
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
    }

    private void drawBlock(TextureManager manager, Tessellator t) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        manager.func_110577_a(TextureMap.field_110575_b);
        this.blockRender.func_147775_a(this.block);
        t.func_78382_b();
        this.blockRender.func_147798_e(Blocks.field_150348_b, -0.5, -0.5, -0.5, this.block.func_149691_a(4, this.meta));
        this.blockRender.func_147764_f(Blocks.field_150348_b, -0.5, -0.5, -0.5, this.block.func_149691_a(5, this.meta));
        this.blockRender.func_147806_b(Blocks.field_150348_b, -0.5, -0.5, -0.5, this.block.func_149691_a(1, this.meta));
        this.blockRender.func_147768_a(Blocks.field_150348_b, -0.5, -0.5, -0.5, this.block.func_149691_a(0, this.meta));
        this.blockRender.func_147761_c(Blocks.field_150348_b, -0.5, -0.5, -0.5, this.block.func_149691_a(2, this.meta));
        this.blockRender.func_147734_d(Blocks.field_150348_b, -0.5, -0.5, -0.5, this.block.func_149691_a(3, this.meta));
        t.func_78381_a();
    }

    private void toggleSide(ForgeDirection side) {
        boolean wasntPresent;
        boolean bl = wasntPresent = !this.selectedSides.remove(side);
        if (wasntPresent) {
            this.selectedSides.add(side);
        }
        this.notifyListeners(side, wasntPresent);
    }

    private void notifyListeners(ForgeDirection side, boolean wasntPresent) {
        if (this.sideSelectedListener != null) {
            this.sideSelectedListener.onSideToggled(side, wasntPresent);
        }
    }

    @Override
    public void mouseUp(int mouseX, int mouseY, int button) {
        super.mouseDown(mouseX, mouseY, button);
        if (button == 0 && this.ticksSinceLastMouseEvent < 10 && this.lastSideHovered != null && this.lastSideHovered != ForgeDirection.UNKNOWN) {
            this.toggleSide(this.lastSideHovered);
            this.ticksSinceLastMouseEvent = 0;
        }
    }

    @Override
    public void mouseDown(int mouseX, int mouseY, int button) {
        super.mouseDown(mouseX, mouseY, button);
        this.ticksSinceLastMouseEvent = 0;
        this.lastSideHovered = null;
    }

    @Override
    public int getWidth() {
        return 50;
    }

    @Override
    public int getHeight() {
        return 50;
    }

    @Override
    public void setValue(Set<ForgeDirection> dirs) {
        this.selectedSides.clear();
        this.selectedSides.addAll(dirs);
    }

    @Override
    public void setValue(IReadableBitMap<ForgeDirection> dirs) {
        this.selectedSides.clear();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (!dirs.get(dir)) continue;
            this.selectedSides.add(dir);
        }
    }

    public void setListener(ISideSelectedListener sideSelectedListener) {
        this.sideSelectedListener = sideSelectedListener;
    }

    public static interface ISideSelectedListener
    extends IListenerBase {
        public void onSideToggled(ForgeDirection var1, boolean var2);
    }
}

