/*
 * Decompiled with CFR 0.152.
 */
package openmods.gui.component.page;

import java.awt.Desktop;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import openmods.gui.component.BaseComponent;
import openmods.gui.component.EmptyComposite;
import openmods.gui.component.GuiComponentCraftingGrid;
import openmods.gui.component.GuiComponentItemStackSpinner;
import openmods.gui.component.GuiComponentLabel;
import openmods.gui.component.GuiComponentSprite;
import openmods.gui.component.page.PageBase;
import openmods.gui.listener.IMouseDownListener;
import openmods.utils.render.FakeIcon;

public class StandardRecipePage
extends PageBase {
    public static IIcon iconCraftingGrid = FakeIcon.createSheetIcon(0, 180, 56, 56);
    public static IIcon iconArrow = FakeIcon.createSheetIcon(60, 198, 48, 15);
    public static IIcon iconYoutube = FakeIcon.createSheetIcon(0, 236, 12, 8);
    private GuiComponentCraftingGrid craftingGrid;
    private GuiComponentSprite arrow;
    private GuiComponentLabel lblDescription;
    private GuiComponentLabel lblTitle;
    private GuiComponentItemStackSpinner outputSpinner;

    public StandardRecipePage(String title, String description, String videoLink, ItemStack resultingItem) {
        String translatedTitle = StatCollector.func_74838_a((String)title);
        String translatedDescription = StatCollector.func_74838_a((String)description).replaceAll("\\\\n", "\n");
        String translatedLink = StatCollector.func_74838_a((String)videoLink);
        if (videoLink != "" && !videoLink.equals(translatedLink)) {
            this.addComponent(StandardRecipePage.createYoutubeButton(25, 146, translatedLink));
        }
        this.lblTitle = new GuiComponentLabel((this.getWidth() - Minecraft.func_71410_x().field_71466_p.func_78256_a(translatedTitle)) / 2, 12, translatedTitle);
        this.lblDescription = new GuiComponentLabel(27, 95, 340, 51, translatedDescription);
        this.arrow = new GuiComponentSprite(90, 50, iconArrow, BOOK_TEXTURE);
        this.craftingGrid = new GuiComponentCraftingGrid(25, 30, StandardRecipePage.getFirstRecipeForItem(resultingItem), iconCraftingGrid, BOOK_TEXTURE);
        this.lblDescription.setScale(0.5f);
        this.lblDescription.setAdditionalLineHeight(4);
        this.outputSpinner = new GuiComponentItemStackSpinner(150, 40, resultingItem);
        this.addComponent(this.lblDescription);
        this.addComponent(this.lblTitle);
        this.addComponent(this.arrow);
        this.addComponent(this.outputSpinner);
        this.addComponent(this.craftingGrid);
    }

    private static void openURI(URI uri) {
        try {
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static BaseComponent createYoutubeButton(int x, int y, final String link) {
        EmptyComposite result = new EmptyComposite(x, y, 50, 8);
        GuiComponentLabel label = new GuiComponentLabel(15, 2, StatCollector.func_74838_a((String)"openblocks.gui.watch_video"));
        label.setScale(0.5f);
        result.addComponent(label);
        GuiComponentSprite image = new GuiComponentSprite(0, 0, iconYoutube, BOOK_TEXTURE);
        result.addComponent(image);
        final URI uri = URI.create(link);
        result.setListener(new IMouseDownListener(){

            @Override
            public void componentMouseDown(BaseComponent component, int x, int y, int button) {
                final Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71474_y.field_74358_q) {
                    final GuiScreen prevGui = mc.field_71462_r;
                    mc.func_147108_a((GuiScreen)new GuiConfirmOpenLink(new GuiYesNoCallback(){

                        public void func_73878_a(boolean result, int id) {
                            if (result) {
                                StandardRecipePage.openURI(uri);
                            }
                            mc.func_147108_a(prevGui);
                        }
                    }, link, 0, false));
                } else {
                    StandardRecipePage.openURI(uri);
                }
            }
        });
        return result;
    }

    private static ItemStack[] getFirstRecipeForItem(ItemStack resultingItem) {
        ItemStack[] recipeItems = new ItemStack[9];
        for (IRecipe recipe : CraftingManager.func_77594_a().func_77592_b()) {
            Object[] input;
            ItemStack result;
            if (recipe == null || (result = recipe.func_77571_b()) == null || !result.func_77969_a(resultingItem) || (input = StandardRecipePage.getRecipeInput(recipe)) == null) continue;
            for (int i = 0; i < input.length; ++i) {
                recipeItems[i] = StandardRecipePage.convertToStack(input[i]);
            }
        }
        return recipeItems;
    }

    protected static ItemStack convertToStack(Object obj) {
        List list;
        ItemStack entry = null;
        if (obj instanceof ItemStack) {
            entry = (ItemStack)obj;
        } else if (obj instanceof List && (list = (List)obj).size() > 0) {
            entry = (ItemStack)list.get(0);
        }
        if (entry == null) {
            return null;
        }
        if ((entry = entry.func_77946_l()).func_77960_j() == Short.MAX_VALUE) {
            entry.func_77964_b(0);
        }
        return entry;
    }

    private static Object[] getRecipeInput(IRecipe recipe) {
        if (recipe instanceof ShapelessOreRecipe) {
            return ((ShapelessOreRecipe)recipe).getInput().toArray();
        }
        if (recipe instanceof ShapedOreRecipe) {
            return StandardRecipePage.getShapedOreRecipe((ShapedOreRecipe)recipe);
        }
        if (recipe instanceof ShapedRecipes) {
            return ((ShapedRecipes)recipe).field_77574_d;
        }
        if (recipe instanceof ShapelessRecipes) {
            return ((ShapelessRecipes)recipe).field_77579_b.toArray(new ItemStack[0]);
        }
        return null;
    }

    private static Object[] getShapedOreRecipe(ShapedOreRecipe recipe) {
        try {
            Field field = ShapedOreRecipe.class.getDeclaredField("width");
            if (field != null) {
                field.setAccessible(true);
                int width = field.getInt(recipe);
                Object[] input = recipe.getInput();
                Object[] grid = new Object[9];
                int i = 0;
                int offset = 0;
                for (int y = 0; y < 3; ++y) {
                    int x = 0;
                    while (x < 3) {
                        if (x < width && offset < input.length) {
                            grid[i] = input[offset];
                            ++offset;
                        } else {
                            grid[i] = null;
                        }
                        ++x;
                        ++i;
                    }
                }
                return grid;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

