/*
 * Decompiled with CFR 0.152.
 */
package openmods.movement;

import openmods.Log;
import openmods.asm.MappedType;
import openmods.asm.MethodMatcher;
import openmods.asm.StopTransforming;
import openmods.movement.PlayerMovementManager;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class MovementPatcher
extends ClassVisitor {
    private static final String MANAGER_CLASS = Type.getInternalName(PlayerMovementManager.class);
    private final Method callbackMethod;
    private final MethodMatcher injectedMethodMatcher;
    private final MethodMatcher calledMethodMatcher;

    public MovementPatcher(String obfClassName, ClassVisitor cv) {
        super(262144, cv);
        MappedType movementInput = MappedType.of("net/minecraft/util/MovementInput");
        MappedType entityPlayer = MappedType.of("net/minecraft/entity/player/EntityPlayer");
        this.calledMethodMatcher = new MethodMatcher(movementInput, "()V", "updatePlayerMoveState", "func_78898_a");
        this.injectedMethodMatcher = new MethodMatcher(obfClassName, "()V", "onLivingUpdate", "func_70636_d");
        this.callbackMethod = new Method("updateMovementState", Type.VOID_TYPE, (Type[])ArrayUtils.toArray((Object[])new Type[]{movementInput.type(), entityPlayer.type()}));
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        return this.injectedMethodMatcher.match(name, desc) ? new CallInjector(parent) : parent;
    }

    private class CallInjector
    extends MethodVisitor {
        public CallInjector(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            boolean patch;
            boolean bl = patch = opcode == 182 && MovementPatcher.this.calledMethodMatcher.match(name, desc);
            if (patch) {
                if (PlayerMovementManager.callbackInjected) {
                    Log.warn("Method code mismatch, aborting", new Object[0]);
                    PlayerMovementManager.callbackInjected = false;
                    throw new StopTransforming();
                }
                this.visitInsn(89);
            }
            super.visitMethodInsn(opcode, owner, name, desc);
            if (patch) {
                this.visitVarInsn(25, 0);
                this.visitMethodInsn(184, MANAGER_CLASS, MovementPatcher.this.callbackMethod.getName(), MovementPatcher.this.callbackMethod.getDescriptor());
                Log.info("Callback inserted. Using new movement handler.", new Object[0]);
                PlayerMovementManager.callbackInjected = true;
            }
        }
    }
}

