/*
 * Decompiled with CFR 0.152.
 */
package openmods.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.util.concurrent.GenericFutureListener;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import openmods.network.DimCoord;
import openmods.network.ExtendedOutboundHandler;
import openmods.network.IPacketTargetSelector;
import openmods.network.targets.SelectChunkWatchers;
import openmods.network.targets.SelectEntityWatchers;
import openmods.utils.NetUtils;

public abstract class Dispatcher<M> {
    protected abstract FMLEmbeddedChannel getChannel(Side var1);

    private void sendmsg(M msg, Object target, Object arg, Side side) {
        if (msg == null) {
            return;
        }
        FMLEmbeddedChannel channel = this.getChannel(side);
        if (target instanceof FMLOutboundHandler.OutboundTarget) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)((FMLOutboundHandler.OutboundTarget)target));
        } else if (target instanceof IPacketTargetSelector) {
            channel.attr(ExtendedOutboundHandler.MESSAGETARGET).set((Object)((IPacketTargetSelector)target));
        } else {
            throw new IllegalArgumentException("Invalid target class: " + target);
        }
        if (arg != null) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(arg);
        }
        channel.writeAndFlush(msg).addListener((GenericFutureListener)NetUtils.THROWING_LISTENER);
    }

    public void sendToPlayer(M msg, EntityPlayerMP player) {
        this.sendmsg(msg, FMLOutboundHandler.OutboundTarget.PLAYER, player, Side.SERVER);
    }

    public void sendToDimension(M msg, int dimensionId) {
        this.sendmsg(msg, FMLOutboundHandler.OutboundTarget.DIMENSION, dimensionId, Side.SERVER);
    }

    public void sendToAll(M msg) {
        this.sendmsg(msg, FMLOutboundHandler.OutboundTarget.ALL, null, Side.SERVER);
    }

    public void sendToAllAround(M msg, NetworkRegistry.TargetPoint point) {
        this.sendmsg(msg, FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT, point, Side.SERVER);
    }

    public void sendToBlockWatchers(M msg, DimCoord point) {
        this.sendmsg(msg, new SelectChunkWatchers(), point, Side.SERVER);
    }

    public void sendToEntityWatchers(M msg, Entity entity) {
        this.sendmsg(msg, new SelectEntityWatchers(), entity, Side.SERVER);
    }

    public void sendToServer(M msg) {
        this.sendmsg(msg, FMLOutboundHandler.OutboundTarget.TOSERVER, null, Side.CLIENT);
    }
}

