/*
 * Decompiled with CFR 0.152.
 */
package openmods.network;

import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.SimpleChannelInboundHandler;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import net.minecraft.network.INetHandler;
import openmods.Log;
import openmods.datastore.DataStoreBuilder;
import openmods.datastore.DataStoreKey;
import openmods.datastore.DataStoreManager;
import openmods.datastore.DataStoreReader;
import openmods.datastore.DataStoreWrapper;
import openmods.datastore.DataStoreWriter;

public class IdSyncManager
extends DataStoreManager {
    private static final String CHANNEL_NAME = "OpenMods|I";
    private final Map<Side, FMLEmbeddedChannel> channels = NetworkRegistry.INSTANCE.newChannel("OpenMods|I", new ChannelHandler[]{new InboundHandler()});
    public static final IdSyncManager INSTANCE = new IdSyncManager();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FMLProxyPacket serializeToPacket(DataStoreKey<?, ?> key, DataStoreWriter<?, ?> writer) {
        ByteBuf payload = Unpooled.buffer();
        Closer closer = Closer.create();
        try {
            try {
                OutputStream raw = (OutputStream)closer.register((Closeable)new ByteBufOutputStream(payload));
                OutputStream compressed = (OutputStream)closer.register((Closeable)new GZIPOutputStream(raw));
                DataOutputStream output = new DataOutputStream(compressed);
                output.writeUTF(key.id);
                writer.write(output);
            }
            finally {
                closer.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new FMLProxyPacket(payload.copy(), CHANNEL_NAME);
    }

    private IdSyncManager() {
    }

    public <K, V> DataStoreBuilder<K, V> createDataStore(String domain, String id, Class<? extends K> keyClass, Class<? extends V> valueClass) {
        String fullId = domain + ":" + id;
        return this.createDataStore(fullId, keyClass, valueClass);
    }

    @Override
    public <K, V> DataStoreBuilder<K, V> createDataStore(String id, Class<? extends K> keyClass, Class<? extends V> valueClass) {
        Preconditions.checkState((!Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION) ? 1 : 0) != 0, (Object)"This method cannot be called in post-initialization state and later");
        return super.createDataStore(id, keyClass, valueClass);
    }

    private void sendAllIds(ChannelHandlerContext ctx) {
        this.validate();
        for (Map.Entry e : this.dataStoreMeta.entrySet()) {
            FMLProxyPacket packet = IdSyncManager.serializeToPacket((DataStoreKey)e.getKey(), ((DataStoreWrapper)e.getValue()).createWriter());
            ctx.write((Object)packet);
        }
    }

    public void finishLoading() {
        this.validate();
        FMLCommonHandler.instance().bus().register((Object)new NetEventHandler());
    }

    public class NetEventHandler {
        @SubscribeEvent
        public void onJoin(FMLNetworkEvent.CustomPacketRegistrationEvent<? extends INetHandler> evt) {
            if (!evt.manager.func_150731_c() && evt.registrations.contains((Object)IdSyncManager.CHANNEL_NAME)) {
                Object handler = evt.side == Side.SERVER ? new ServerHandshakeHijacker() : new ClientHandshakeHijacker();
                evt.manager.channel().pipeline().addAfter("fml:packet_handler", "openmods:id_injector", (ChannelHandler)handler);
            }
        }

        @SubscribeEvent
        public void onHandshakeComplete(FMLNetworkEvent.ClientConnectedToServerEvent evt) {
            if (!evt.manager.func_150731_c()) {
                try {
                    evt.manager.channel().pipeline().remove("openmods:id_injector");
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        }

        @SubscribeEvent
        public void onDisconnect(FMLNetworkEvent.ClientDisconnectionFromServerEvent evt) {
            IdSyncManager.this.activateLocalData();
        }
    }

    @ChannelHandler.Sharable
    private class InboundHandler
    extends SimpleChannelInboundHandler<FMLProxyPacket> {
        private InboundHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void channelRead0(ChannelHandlerContext ctx, FMLProxyPacket msg) throws Exception {
            ByteBuf buf = msg.payload();
            try {
                Closer closer = Closer.create();
                try {
                    InputStream raw = (InputStream)closer.register((Closeable)new ByteBufInputStream(buf));
                    InputStream compressed = (InputStream)closer.register((Closeable)new GZIPInputStream(raw));
                    DataInputStream input = new DataInputStream(compressed);
                    String keyId = input.readUTF();
                    Log.debug("Received data store for key %s, packet size = %d", keyId, buf.writerIndex());
                    DataStoreWrapper wrapper = IdSyncManager.this.getDataStoreMeta(keyId);
                    DataStoreReader reader = wrapper.createReader();
                    reader.read(input);
                }
                finally {
                    closer.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class ClientHandshakeHijacker
    extends SimpleChannelInboundHandler<FMLProxyPacket> {
        private ClientHandshakeHijacker() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, FMLProxyPacket msg) throws Exception {
            if (msg.channel().equals(IdSyncManager.CHANNEL_NAME)) {
                ((FMLEmbeddedChannel)IdSyncManager.this.channels.get(Side.CLIENT)).writeInbound(new Object[]{msg});
            } else {
                ctx.fireChannelRead((Object)msg);
            }
        }
    }

    private class ServerHandshakeHijacker
    extends ChannelOutboundHandlerAdapter {
        private ServerHandshakeHijacker() {
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            FMLProxyPacket hijackedMsg;
            ctx.writeAndFlush(msg);
            if (msg instanceof FMLProxyPacket && (hijackedMsg = (FMLProxyPacket)msg).channel().equals("FML|HS")) {
                ByteBuf payload = hijackedMsg.payload();
                byte discriminator = payload.readByte();
                if (discriminator == 3) {
                    IdSyncManager.this.sendAllIds(ctx);
                    ctx.pipeline().remove((ChannelHandler)this);
                } else if (discriminator == -1) {
                    ctx.pipeline().remove((ChannelHandler)this);
                }
            }
        }
    }
}

