/*
 * Decompiled with CFR 0.152.
 */
package openmods.network.rpc;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import openmods.network.rpc.IRpcTarget;
import openmods.network.rpc.MethodIdRegistry;
import openmods.network.rpc.RpcCall;
import openmods.network.rpc.RpcCallDispatcher;
import org.apache.commons.lang3.ArrayUtils;

public class RpcProxyFactory {
    private final MethodIdRegistry registry;
    private final RpcCallDispatcher dispatcher;

    RpcProxyFactory(MethodIdRegistry registry, RpcCallDispatcher dispatcher) {
        this.registry = registry;
        this.dispatcher = dispatcher;
    }

    public <T> T createClientProxy(ClassLoader loader, final IRpcTarget wrapper, Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        Class[] allInterfaces;
        for (Class intf : allInterfaces = (Class[])ArrayUtils.add((Object[])extraIntf, mainIntf)) {
            Preconditions.checkState((boolean)this.registry.isClassRegistered(intf), (String)"Class %s is not registered as RPC interface", (Object[])new Object[]{intf});
        }
        Object proxy = Proxy.newProxyInstance(loader, allInterfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                RpcCall call = new RpcCall(wrapper, method, args);
                RpcProxyFactory.this.dispatcher.sendToServer(call);
                return null;
            }
        });
        return (T)proxy;
    }
}

