/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraftforge.common.MinecraftForge;
import openmods.Log;
import openmods.asm.MappedType;
import openmods.asm.MethodMatcher;
import openmods.renderer.PlayerBodyRenderEvent;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class PlayerRendererHookVisitor
extends ClassVisitor {
    private final MethodMatcher modifiedMethod;

    public static void post(AbstractClientPlayer player, float partialTickTime) {
        MinecraftForge.EVENT_BUS.post((Event)new PlayerBodyRenderEvent(player, partialTickTime));
    }

    public PlayerRendererHookVisitor(String rendererTypeCls, ClassVisitor cv) {
        super(262144, cv);
        Type injectedMethodType = Type.getMethodType((Type)Type.VOID_TYPE, (Type[])new Type[]{MappedType.of(AbstractClientPlayer.class).type(), Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE});
        this.modifiedMethod = new MethodMatcher(rendererTypeCls, injectedMethodType.getDescriptor(), "rotateCorpse", "func_77043_a");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        return this.modifiedMethod.match(name, desc) ? new InjectorMethodVisitor(parent) : parent;
    }

    private static class InjectorMethodVisitor
    extends MethodVisitor {
        private final Method postMethod;

        public InjectorMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
            try {
                this.postMethod = Method.getMethod((java.lang.reflect.Method)PlayerRendererHookVisitor.class.getMethod("post", AbstractClientPlayer.class, Float.TYPE));
            }
            catch (Throwable t) {
                throw Throwables.propagate((Throwable)t);
            }
            Log.info("Injecting hook %s.%s into EntityPlayerRender.rotateCorpse", PlayerRendererHookVisitor.class, this.postMethod);
        }

        public void visitInsn(int opcode) {
            if (opcode == 177) {
                Type hookCls = Type.getType(PlayerRendererHookVisitor.class);
                this.visitVarInsn(25, 1);
                this.visitVarInsn(23, 4);
                this.visitMethodInsn(184, hookCls.getInternalName(), this.postMethod.getName(), this.postMethod.getDescriptor());
                Log.info("Injected!", new Object[0]);
            }
            super.visitInsn(opcode);
        }
    }
}

