/*
 * Decompiled with CFR 0.152.
 */
package openmods.stencil;

import net.minecraft.client.renderer.OpenGlHelper;
import openmods.Log;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public class FramebufferConstants {
    public static int GL_STENCIL_ATTACHMENT;
    public static int GL_FRAMEBUFFER_UNSUPPORTED;
    public static int GL_FRAMEBUFFER_UNDEFINED;
    public static int DEPTH_STENCIL_FORMAT;

    public static void init() {
        ContextCapabilities capabilities = GLContext.getCapabilities();
        if (capabilities.OpenGL30) {
            GL_STENCIL_ATTACHMENT = 36128;
            GL_FRAMEBUFFER_UNSUPPORTED = 36061;
            GL_FRAMEBUFFER_UNDEFINED = 33305;
            DEPTH_STENCIL_FORMAT = 35056;
        } else if (capabilities.GL_ARB_framebuffer_object) {
            GL_STENCIL_ATTACHMENT = 36128;
            GL_FRAMEBUFFER_UNSUPPORTED = 36061;
            GL_FRAMEBUFFER_UNDEFINED = 33305;
            DEPTH_STENCIL_FORMAT = 35056;
        } else if (capabilities.GL_EXT_framebuffer_object) {
            GL_STENCIL_ATTACHMENT = 36128;
            GL_FRAMEBUFFER_UNSUPPORTED = 36061;
            GL_FRAMEBUFFER_UNDEFINED = -1;
            DEPTH_STENCIL_FORMAT = capabilities.GL_EXT_packed_depth_stencil ? 35056 : -1;
        } else {
            throw new IllegalArgumentException("Unable to determine capabilities");
        }
    }

    private static boolean logError(String name) {
        Log.warn("FBO not complete: %s", name);
        return false;
    }

    public static boolean checkFramebufferComplete(int fboStatus) {
        if (fboStatus == OpenGlHelper.field_153202_i) {
            return true;
        }
        if (fboStatus == OpenGlHelper.field_153203_j) {
            return FramebufferConstants.logError("GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT");
        }
        if (fboStatus == OpenGlHelper.field_153205_l) {
            return FramebufferConstants.logError("GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER");
        }
        if (fboStatus == OpenGlHelper.field_153206_m) {
            return FramebufferConstants.logError("GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER");
        }
        if (fboStatus == GL_FRAMEBUFFER_UNSUPPORTED) {
            return FramebufferConstants.logError("GL_FRAMEBUFFER_UNSUPPORTED");
        }
        if (fboStatus == GL_FRAMEBUFFER_UNDEFINED) {
            return FramebufferConstants.logError("GL_FRAMEBUFFER_UNDEFINED");
        }
        return FramebufferConstants.logError(String.format("unknown 0x%04X", fboStatus));
    }

    static {
        DEPTH_STENCIL_FORMAT = -1;
    }
}

