/*
 * Decompiled with CFR 0.152.
 */
package openmods.structured;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import openmods.structured.IStructureElement;
import openmods.utils.InstanceFieldAccess;
import openmods.utils.io.IStreamSerializable;
import openmods.utils.io.TypeRW;

public class ElementField
extends InstanceFieldAccess<Object>
implements IStructureElement {
    public int elementId;
    public final IStreamSerializable<Object> serializer;

    public ElementField(Object parent, Field field) {
        super(parent, field);
        Class<?> fieldType = field.getType();
        this.serializer = TypeRW.TYPES.get(fieldType);
        Preconditions.checkNotNull(this.serializer, (Object)"Invalid field type");
    }

    @Override
    public void writeToStream(DataOutput output) throws IOException {
        Object value = this.get();
        this.serializer.writeToStream(value, output);
    }

    @Override
    public void readFromStream(DataInput input) throws IOException {
        Object value = this.serializer.readFromStream(input);
        this.set(value);
    }
}

