/*
 * Decompiled with CFR 0.152.
 */
package openmods.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.api.IInventoryCallback;
import openmods.block.BlockRotationMode;
import openmods.block.OpenBlock;
import openmods.events.network.TileEntityMessageEventPacket;
import openmods.inventory.GenericInventory;
import openmods.network.rpc.IRpcTarget;
import openmods.network.rpc.IRpcTargetProvider;
import openmods.network.rpc.RpcCallDispatcher;
import openmods.network.rpc.targets.TileEntityRpcTarget;
import openmods.utils.Coord;
import openmods.utils.TypeUtils;

public abstract class OpenTileEntity
extends TileEntity
implements IRpcTargetProvider {
    private boolean initialized = false;
    private boolean isActive = false;
    private boolean isUsedForClientInventoryRendering = false;

    public void setup() {
    }

    public Coord getPosition() {
        return new Coord(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public ForgeDirection getRotation() {
        OpenBlock block = this.getBlock();
        if (this.isUsedForClientInventoryRendering) {
            return block.getInventoryRenderRotation();
        }
        BlockRotationMode rotationMode = block.getRotationMode();
        int metadata = this.getMetadata() & rotationMode.mask;
        return rotationMode.fromValue(metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void prepareForInventoryRender(Block block, int metadata) {
        if (this.field_145850_b != null) {
            System.out.println("SEVERE PROGRAMMER ERROR! Inventory Render on World TileEntity. Expect hell!");
        }
        this.isUsedForClientInventoryRendering = true;
        this.field_145854_h = block;
        this.field_145847_g = metadata;
    }

    public void func_145845_h() {
        this.isActive = true;
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
    }

    protected void initialize() {
    }

    public boolean isLoaded() {
        return this.initialized;
    }

    public boolean isAddedToWorld() {
        return this.field_145850_b != null;
    }

    protected boolean isActive() {
        return this.isActive;
    }

    public void onChunkUnload() {
        this.isActive = false;
    }

    public TileEntity getTileInDirection(ForgeDirection direction) {
        int x = this.field_145851_c + direction.offsetX;
        int y = this.field_145848_d + direction.offsetY;
        int z = this.field_145849_e + direction.offsetZ;
        if (this.field_145850_b != null && this.field_145850_b.func_72899_e(x, y, z)) {
            return this.field_145850_b.func_147438_o(x, y, z);
        }
        return null;
    }

    public String toString() {
        return String.format("%s,%s,%s", this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isAirBlock(ForgeDirection direction) {
        return this.field_145850_b != null && this.field_145850_b.func_147437_c(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
    }

    public void sendBlockEvent(int key, int value) {
        this.field_145850_b.func_147452_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), key, value);
    }

    public boolean shouldRefresh(Block oldBlock, Block newBlock, int oldMeta, int newMeta, World world, int x, int y, int z) {
        return oldBlock != newBlock;
    }

    public OpenBlock getBlock() {
        if (this.field_145854_h instanceof OpenBlock) {
            return (OpenBlock)this.field_145854_h;
        }
        return OpenBlock.getOpenBlock((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getMetadata() {
        if (this.field_145847_g > -1) {
            return this.field_145847_g;
        }
        this.field_145847_g = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return this.field_145847_g;
    }

    public void openGui(Object instance, EntityPlayer player) {
        player.openGui(instance, -1, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public AxisAlignedBB getBB() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1));
    }

    public boolean isRenderedInInventory() {
        return this.isUsedForClientInventoryRendering;
    }

    public void onEvent(TileEntityMessageEventPacket event) {
    }

    @Override
    public IRpcTarget createRpcTarget() {
        return new TileEntityRpcTarget(this);
    }

    public <T> T createRpcProxy(Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        TypeUtils.isInstance(this, mainIntf, extraIntf);
        return RpcCallDispatcher.INSTANCE.createProxy(this.createRpcTarget(), mainIntf, extraIntf);
    }

    public void markUpdated() {
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    protected IInventoryCallback createInventoryCallback() {
        return new IInventoryCallback(){

            @Override
            public void onInventoryChanged(IInventory inventory, int slotNumber) {
                OpenTileEntity.this.markUpdated();
            }
        };
    }

    protected GenericInventory registerInventoryCallback(GenericInventory inventory) {
        return inventory.addCallback(this.createInventoryCallback());
    }
}

