/*
 * Decompiled with CFR 0.152.
 */
package openmods.tileentity;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Set;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraftforge.common.util.ForgeDirection;
import openmods.Log;
import openmods.network.rpc.RpcCallDispatcher;
import openmods.network.rpc.targets.SyncRpcTarget;
import openmods.sync.ISyncListener;
import openmods.sync.ISyncMapProvider;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncChannelHolder;
import openmods.sync.SyncMap;
import openmods.sync.SyncMapTile;
import openmods.sync.SyncObjectScanner;
import openmods.sync.SyncableDirection;
import openmods.tileentity.OpenTileEntity;
import openmods.utils.TypeUtils;

public abstract class SyncedTileEntity
extends OpenTileEntity
implements ISyncMapProvider {
    protected SyncMapTile<SyncedTileEntity> syncMap = new SyncMapTile<SyncedTileEntity>(this);

    public SyncedTileEntity() {
        this.createSyncedFields();
        SyncObjectScanner.INSTANCE.registerAllFields(this.syncMap, this);
        this.syncMap.addSyncListener(new ISyncListener(){

            @Override
            public void onSync(Set<ISyncableObject> changes) {
                SyncedTileEntity.this.markUpdated();
            }
        });
    }

    protected ISyncListener createRenderUpdateListener() {
        return new ISyncListener(){

            @Override
            public void onSync(Set<ISyncableObject> changes) {
                SyncedTileEntity.this.field_145850_b.func_147471_g(SyncedTileEntity.this.field_145851_c, SyncedTileEntity.this.field_145848_d, SyncedTileEntity.this.field_145849_e);
            }
        };
    }

    protected ISyncListener createRenderUpdateListener(final ISyncableObject target) {
        return new ISyncListener(){

            @Override
            public void onSync(Set<ISyncableObject> changes) {
                if (changes.contains(target)) {
                    SyncedTileEntity.this.field_145850_b.func_147471_g(SyncedTileEntity.this.field_145851_c, SyncedTileEntity.this.field_145848_d, SyncedTileEntity.this.field_145849_e);
                }
            }
        };
    }

    protected abstract void createSyncedFields();

    public void addSyncedObject(String name, ISyncableObject obj) {
        this.syncMap.put(name, obj);
    }

    public void sync() {
        this.syncMap.sync();
    }

    public SyncMap<SyncedTileEntity> getSyncMap() {
        return this.syncMap;
    }

    public Packet func_145844_m() {
        try {
            ByteBuf payload = this.syncMap.createPayload(true);
            return SyncChannelHolder.createPacket(payload);
        }
        catch (IOException e) {
            Log.severe(e, "Error during description packet creation", new Object[0]);
            return null;
        }
    }

    public ForgeDirection getSecondaryRotation() {
        ISyncableObject rot = this.syncMap.get("_rotation2");
        if (rot != null) {
            return ((SyncableDirection)rot).getValue();
        }
        return null;
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        this.syncMap.writeToNBT(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.syncMap.readFromNBT(tag);
    }

    public <T> T createRpcProxy(ISyncableObject object, Class<? extends T> mainIntf, Class<?> ... extraIntf) {
        TypeUtils.isInstance(object, mainIntf, extraIntf);
        SyncRpcTarget.SyncTileEntityRpcTarget target = new SyncRpcTarget.SyncTileEntityRpcTarget(this, object);
        return RpcCallDispatcher.INSTANCE.createProxy(target, mainIntf, extraIntf);
    }
}

