/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import openmods.utils.ReflectionHelper;

public class FieldAccess<T> {
    public final Field field;

    public FieldAccess(Field field) {
        this.field = field;
        field.setAccessible(true);
    }

    public T get(Object target) {
        try {
            return (T)this.field.get(target);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void set(Object target, T value) {
        try {
            this.field.set(target, value);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <T> FieldAccess<T> create(Class<?> cls, String ... names) {
        Field f = ReflectionHelper.getField(cls, names);
        return new FieldAccess<T>(f);
    }
}

