/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import com.google.common.base.Throwables;
import java.lang.reflect.Field;
import openmods.utils.ReflectionHelper;

public class InstanceFieldAccess<T> {
    public final Object target;
    public final Field field;

    public InstanceFieldAccess(Object parent, Field field) {
        this.target = parent;
        this.field = field;
        field.setAccessible(true);
    }

    public T get() {
        try {
            return (T)this.field.get(this.target);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void set(T value) {
        try {
            this.field.set(this.target, value);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static <T> InstanceFieldAccess<T> create(Class<?> cls, Object target, String ... names) {
        Field f = ReflectionHelper.getField(cls, names);
        return new InstanceFieldAccess<T>(target, f);
    }

    public static <T> InstanceFieldAccess<T> create(Class<?> cls, String ... names) {
        return InstanceFieldAccess.create(cls, null, names);
    }

    public static <T> InstanceFieldAccess<T> create(Object target, String ... names) {
        return InstanceFieldAccess.create(target.getClass(), target, names);
    }
}

