/*
 * Decompiled with CFR 0.152.
 */
package openmods.utils;

import java.lang.reflect.Method;
import java.util.Arrays;
import openmods.Log;
import openmods.utils.ReflectionHelper;

public class ReflectionMethodCall<T> {
    private final Method method;

    public ReflectionMethodCall(Class<?> targetCls, String[] names, Class<?> ... args) {
        Method method = null;
        try {
            method = ReflectionHelper.getMethod(targetCls, names, args);
            method.setAccessible(true);
        }
        catch (Throwable t) {
            Log.warn(t, "Failed to get method '%s.%s(%s)'", targetCls, Arrays.toString(names), Arrays.toString(args));
        }
        this.method = method;
    }

    public T call(Object target, Object ... args) {
        if (this.method != null) {
            try {
                return (T)this.method.invoke(target, args);
            }
            catch (Throwable t) {
                Log.warn(t, "Can't call method. Oh, well...", new Object[0]);
            }
        }
        return null;
    }
}

