/*
 * Decompiled with CFR 0.152.
 */
package openmods.world;

import openmods.Log;
import openmods.asm.MappedType;
import openmods.asm.MethodMatcher;
import openmods.asm.VisitorHelper;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

public class MapGenStructureVisitor
extends ClassVisitor {
    private final MethodMatcher modifiedMethod;
    private final MethodMatcher markerMethod;
    private final MappedType structureStartCls = MappedType.of("net/minecraft/world/gen/structure/StructureStart");

    public MapGenStructureVisitor(String obfClassName, ClassVisitor cv) {
        super(262144, cv);
        MappedType chunkPositionCls = MappedType.of("net/minecraft/world/ChunkPosition");
        MappedType worldCls = MappedType.of("net/minecraft/world/World");
        String descriptor = Type.getMethodDescriptor((Type)chunkPositionCls.type(), (Type[])new Type[]{worldCls.type(), Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE});
        this.modifiedMethod = new MethodMatcher(obfClassName, descriptor, "func_151545_a", "func_151545_a");
        this.markerMethod = new MethodMatcher(this.structureStartCls, "()Z", "isSizeableStructure", "func_75069_d");
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor parent = super.visitMethod(access, name, desc, signature, exceptions);
        return this.modifiedMethod.match(name, desc) ? new FixerMethodVisitor(parent) : parent;
    }

    private class FixerMethodVisitor
    extends MethodVisitor {
        private boolean checkcastFound;
        private Integer localVarId;
        private boolean markerMethodFound;

        public FixerMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitTypeInsn(int opcode, String type) {
            super.visitTypeInsn(opcode, type);
            if (opcode == 192 && type.equals(MapGenStructureVisitor.this.structureStartCls.name())) {
                this.checkcastFound = true;
                Log.info("Found checkcast to '%s'", type);
            }
        }

        public void visitVarInsn(int opcode, int var) {
            super.visitVarInsn(opcode, var);
            if (this.checkcastFound && opcode == 58) {
                this.localVarId = var;
                this.checkcastFound = false;
                Log.info("Found var: %d", this.localVarId);
            }
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
            super.visitMethodInsn(opcode, owner, name, desc);
            if (opcode == 182 && owner.equals(MapGenStructureVisitor.this.structureStartCls.name()) && MapGenStructureVisitor.this.markerMethod.match(name, desc)) {
                this.markerMethodFound = true;
                Log.info("Found 'StructureStart.isSizeableStructure' (%s.%s) call", owner, name);
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (this.markerMethodFound && this.localVarId != null && opcode == 153) {
                Log.info("All conditions matched, inserting extra condition", new Object[0]);
                super.visitVarInsn(25, this.localVarId.intValue());
                String getComponentsMethodName = VisitorHelper.useSrgNames() ? "func_75073_b" : "getComponents";
                super.visitMethodInsn(182, MapGenStructureVisitor.this.structureStartCls.name(), getComponentsMethodName, "()Ljava/util/LinkedList;");
                super.visitMethodInsn(182, "java/util/LinkedList", "isEmpty", "()Z");
                super.visitJumpInsn(154, label);
                this.markerMethodFound = false;
            }
        }
    }
}

