/*
 * Decompiled with CFR 0.152.
 */
package reifnsk.minimap;

final class BlockData
implements Comparable<BlockData> {
    protected static final Object ETC_EMPTY = "EMPTY";
    protected final int renderType;
    protected final int renderPass;
    protected final String textureName;
    protected final float minX;
    protected final float minY;
    protected final float minZ;
    protected final float maxX;
    protected final float maxY;
    protected final float maxZ;
    protected final int hashCode;
    protected final Object extend;

    protected BlockData(int renderType, int renderPass, String textureName, float minX, float minY, float minZ, float maxX, float maxY, float maxZ, Object ex) {
        if (textureName == null) {
            throw new IllegalArgumentException();
        }
        if (ex == null) {
            ex = ETC_EMPTY;
        }
        this.renderType = renderType;
        this.renderPass = renderPass;
        this.textureName = textureName;
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        this.extend = ex;
        int hash = renderType ^ textureName.hashCode();
        hash ^= Float.floatToRawIntBits(minX + 1.0f);
        hash ^= Float.floatToRawIntBits(minY + 2.0f);
        hash ^= Float.floatToRawIntBits(minZ + 3.0f);
        hash ^= Float.floatToRawIntBits(maxX + 4.0f);
        hash ^= Float.floatToRawIntBits(maxZ + 5.0f);
        hash ^= Float.floatToRawIntBits(maxY + 6.0f);
        this.hashCode = hash ^= ex.hashCode();
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        return obj != null && this == obj || obj instanceof BlockData && this.equals((BlockData)obj);
    }

    private boolean equals(BlockData obj) {
        return this.renderType == obj.renderType && this.minX == obj.minX && this.minY == obj.minY && this.minZ == obj.minZ && this.maxX == obj.maxX && this.maxY == obj.maxY && this.maxZ == obj.maxZ && BlockData.equals(this.textureName, obj.textureName) && this.extend.equals(obj.extend);
    }

    private static boolean equals(String s1, String s2) {
        return s1 == s2 || s1 != null && s1.equals(s2);
    }

    @Override
    public int compareTo(BlockData o) {
        int i = this.textureName.compareTo(o.textureName);
        return i != 0 ? i : (this.renderType != o.renderType ? this.renderType - o.renderType : (this.renderPass != o.renderPass ? this.renderPass - o.renderPass : this.extend.toString().compareTo(o.extend.toString())));
    }

    public String toString() {
        return String.format("%s:%d (%1.6f,%1.6f,%1.6f)-(%1.6f,%1.6f,%1.6f) : %s", this.textureName, this.renderType, Float.valueOf(this.minX), Float.valueOf(this.minY), Float.valueOf(this.minZ), Float.valueOf(this.maxX), Float.valueOf(this.maxY), Float.valueOf(this.maxZ), this.extend);
    }
}

