/*
 * Decompiled with CFR 0.152.
 */
package resonant.api.recipe;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import resonant.api.recipe.RecipeResource;

public final class MachineRecipes {
    public static MachineRecipes INSTANCE = new MachineRecipes();
    private final Map<String, Map<RecipeResource[], RecipeResource[]>> recipes = new HashMap<String, Map<RecipeResource[], RecipeResource[]>>();

    public RecipeResource getResourceFromObject(Object obj) {
        if (obj instanceof String) {
            return new RecipeResource.OreDictResource((String)obj);
        }
        if (obj instanceof Block) {
            return new RecipeResource.ItemStackResource(new ItemStack((Block)obj));
        }
        if (obj instanceof Item) {
            return new RecipeResource.ItemStackResource(new ItemStack((Item)obj));
        }
        if (obj instanceof ItemStack) {
            return new RecipeResource.ItemStackResource((ItemStack)obj);
        }
        if (obj instanceof FluidStack) {
            return new RecipeResource.FluidStackResource((FluidStack)obj);
        }
        if (obj instanceof RecipeResource) {
            return (RecipeResource)obj;
        }
        return null;
    }

    public void addRecipe(String machine, Object inputObj, Object ... outputObj) {
        this.addRecipe(machine, new Object[]{inputObj}, outputObj);
    }

    public void addRecipe(String machine, Object[] inputObj, Object[] outputObj) {
        RecipeResource[] inputs = new RecipeResource[inputObj.length];
        for (int i = 0; i < inputs.length; ++i) {
            RecipeResource input = this.getResourceFromObject(inputObj[i]);
            if (input == null) {
                throw new RuntimeException("Tried to add invalid " + machine + " recipe input: " + inputObj[i]);
            }
            inputs[i] = input;
        }
        RecipeResource[] outputs = new RecipeResource[outputObj.length];
        for (int i = 0; i < outputs.length; ++i) {
            RecipeResource output = this.getResourceFromObject(outputObj[i]);
            if (output == null) {
                throw new RuntimeException("Tried to add invalid " + machine + " recipe output: " + outputObj[i]);
            }
            outputs[i] = output;
        }
        this.addRecipe(machine, inputs, outputs);
    }

    public void addRecipe(String machine, RecipeResource[] input, RecipeResource[] output) {
        this.getRecipes(machine).put(input, output);
    }

    public void removeRecipe(String machine, RecipeResource[] input) {
        this.getRecipes(machine).remove(input);
    }

    public Map<RecipeResource[], RecipeResource[]> getRecipes(String machine) {
        if (!this.recipes.containsKey(machine = machine.toLowerCase(Locale.ENGLISH))) {
            this.recipes.put(machine, new HashMap());
        }
        return this.recipes.get(machine);
    }

    public RecipeResource[] getOutput(String machine, RecipeResource ... input) {
        for (Map.Entry<RecipeResource[], RecipeResource[]> entry : this.getRecipes(machine).entrySet()) {
            Object[] compare = entry.getKey();
            Object[] copyA = Arrays.copyOf(input, input.length);
            Object[] copyB = Arrays.copyOf(compare, compare.length);
            Arrays.sort(copyA);
            Arrays.sort(copyB);
            if (!Arrays.equals(compare, input) && !Arrays.equals(copyA, copyB)) continue;
            return entry.getValue();
        }
        return new RecipeResource[0];
    }

    public RecipeResource[] getOutput(String machine, Object ... inputs) {
        RecipeResource[] resourceInputs = new RecipeResource[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            resourceInputs[i] = this.getResourceFromObject(inputs[i]);
        }
        return this.getOutput(machine, resourceInputs);
    }
}

