/*
 * Decompiled with CFR 0.152.
 */
package resonant.content.factory.resources.block;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import resonant.content.factory.resources.FactoryResource;
import resonant.content.factory.resources.ResourceFactoryHandler;
import resonant.content.factory.resources.block.BlockFluidMixture;
import resonant.lib.prefab.block.FluidColored;
import resonant.lib.render.RenderUtility;
import resonant.lib.utility.LanguageUtility;

public class FactoryFluidMixture
extends FactoryResource {
    public final HashMap<Integer, BlockFluidFinite> blockMixtureFluids = new HashMap();

    public FactoryFluidMixture(ResourceFactoryHandler gen, String modID, String prefix) {
        super(gen, modID, prefix);
    }

    public BlockFluidMixture generate(String materialName, Object ... data) {
        String mixtureName = "molten_" + materialName;
        Fluid fluidMixture = new FluidColored(mixtureName).setDensity(3);
        if (FluidRegistry.registerFluid((Fluid)fluidMixture)) {
            fluidMixture = FluidRegistry.getFluid((String)mixtureName);
        }
        BlockFluidMixture blockFluidMixture = new BlockFluidMixture(fluidMixture);
        blockFluidMixture.func_149663_c(this.prefix + "mixture" + LanguageUtility.capitalizeFirst(materialName));
        GameRegistry.registerBlock((Block)blockFluidMixture, (String)("mixture" + LanguageUtility.capitalizeFirst(materialName)));
        return blockFluidMixture;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void postTextureHook(TextureStitchEvent.Post event) {
        for (BlockFluidFinite block : this.blockMixtureFluids.values()) {
            block.getFluid().setIcons(RenderUtility.getIcon(this.prefix + "mixture_flow"));
            ((FluidColored)block.getFluid()).setColor(this.gen.getColor(this.gen.mixtureToMaterial(block.getFluid().getName())));
        }
    }
}

