/*
 * Decompiled with CFR 0.152.
 */
package resonant.content.factory.resources.item;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.OreDictionary;
import resonant.api.recipe.MachineRecipes;
import resonant.content.factory.resources.FactoryResource;
import resonant.content.factory.resources.RecipeType;
import resonant.content.factory.resources.ResourceFactoryHandler;
import resonant.content.factory.resources.item.ItemResourceDust;
import resonant.lib.utility.LanguageUtility;

public class FactoryDust
extends FactoryResource {
    public static Item dust;
    public static Item dirtDust;

    public FactoryDust(ResourceFactoryHandler gen, String modID, String prefix) {
        super(gen, modID, prefix);
    }

    @Override
    public Object generate(String objectName, Object ... data) {
        if (dust == null) {
            dust = new ItemResourceDust(false);
            dust.func_77637_a(CreativeTabs.field_78035_l);
            GameRegistry.registerItem((Item)dust, (String)"metalDust", (String)this.modID);
        }
        if (dirtDust == null) {
            dirtDust = new ItemResourceDust(true);
            dirtDust.func_77637_a(CreativeTabs.field_78035_l);
            GameRegistry.registerItem((Item)dirtDust, (String)"metalDirtyDust", (String)this.modID);
        }
        ItemStack dustStack = null;
        ItemStack dirtStack = null;
        if (this.gen.materialIds.inverse().containsKey((Object)objectName)) {
            Fluid fluid;
            dustStack = new ItemStack(dust, 1, ((Integer)this.gen.materialIds.inverse().get((Object)objectName)).intValue());
            dirtStack = new ItemStack(dirtDust, 1, ((Integer)this.gen.materialIds.inverse().get((Object)objectName)).intValue());
            OreDictionary.registerOre((String)("dirtyDust" + LanguageUtility.capitalizeFirst(objectName)), (ItemStack)dirtStack);
            OreDictionary.registerOre((String)("dust" + LanguageUtility.capitalizeFirst(objectName)), (ItemStack)dirtStack);
            OreDictionary.registerOre((String)("dust" + LanguageUtility.capitalizeFirst(objectName)), (ItemStack)dustStack);
            MachineRecipes.INSTANCE.addRecipe(RecipeType.GRINDER.name(), "rubble" + LanguageUtility.capitalizeFirst(objectName), dirtDust, dirtDust);
            MachineRecipes.INSTANCE.addRecipe(RecipeType.MIXER.name(), "dirtyDust" + LanguageUtility.capitalizeFirst(objectName), dust, dust);
            ArrayList ingots = OreDictionary.getOres((String)("ingot" + LanguageUtility.capitalizeFirst(objectName)));
            if (ingots != null && !ingots.isEmpty()) {
                ItemStack ingot = ((ItemStack)ingots.get(0)).func_77946_l();
                ingot.field_77994_a = 1;
                GameRegistry.addSmelting((ItemStack)dirtStack, (ItemStack)ingot, (float)0.7f);
                ingot.field_77994_a = 2;
                GameRegistry.addSmelting((ItemStack)dustStack, (ItemStack)ingot, (float)0.7f);
            }
            if ((fluid = FluidRegistry.getFluid((String)("molten_" + objectName))) != null) {
                // empty if block
            }
        }
        return dustStack;
    }
}

