/*
 * Decompiled with CFR 0.152.
 */
package resonant.content.loader;

import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.WeakHashMap;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import resonant.content.CommonRegistryProxy;
import resonant.content.prefab.itemblock.ItemBlockMetadata;
import resonant.content.prefab.scala.render.ISimpleItemRenderer;
import resonant.content.spatial.block.SpatialBlock;
import resonant.content.wrapper.BlockDummy;
import resonant.content.wrapper.ItemRenderHandler;
import resonant.lib.utility.LanguageUtility;

public class ModManager {
    @SidedProxy(clientSide="resonant.content.ClientRegistryProxy", serverSide="resonant.content.CommonRegistryProxy")
    public static CommonRegistryProxy proxy;
    public final WeakHashMap<Block, String> blocks = new WeakHashMap();
    public final WeakHashMap<Item, String> items = new WeakHashMap();
    private String modPrefix;
    private CreativeTabs defaultTab;

    public ModManager setPrefix(String modPrefix) {
        this.modPrefix = modPrefix;
        return this;
    }

    public ModManager setTab(CreativeTabs defaultTab) {
        this.defaultTab = defaultTab;
        return this;
    }

    public BlockDummy newBlock(Class<? extends SpatialBlock> spatialClass, Object ... args) {
        try {
            SpatialBlock spatial;
            if (args != null && args.length > 0) {
                ArrayList paramTypes = new ArrayList();
                for (Object arg : args) {
                    paramTypes.add(arg.getClass());
                }
                spatial = spatialClass.getConstructor(paramTypes.toArray(new Class[0])).newInstance(new Object[0]);
            } else {
                spatial = spatialClass.newInstance();
            }
            return this.newBlock(spatial);
        }
        catch (Exception e) {
            throw new RuntimeException("Block [" + spatialClass.getSimpleName() + "] failed to be created:", e);
        }
    }

    public BlockDummy newBlock(SpatialBlock spatial) {
        return this.newBlock(spatial.name(), spatial);
    }

    public BlockDummy newBlock(String name, SpatialBlock spatial) {
        BlockDummy block = new BlockDummy(this.modPrefix, this.defaultTab, spatial);
        spatial.setBlock(block);
        this.blocks.put(block, name);
        GameRegistry.registerBlock((Block)block, spatial.itemBlock(), (String)name);
        spatial.onInstantiate();
        if (spatial instanceof ISimpleItemRenderer) {
            ItemRenderHandler.register(new ItemStack((Block)block).func_77973_b(), (ISimpleItemRenderer)((Object)spatial));
        }
        if (spatial.tile() != null) {
            proxy.registerTileEntity(name, this.modPrefix, ((Object)((Object)spatial.tile())).getClass());
            if (!spatial.normalRender()) {
                proxy.registerDummyRenderer(((Object)((Object)spatial.tile())).getClass());
            }
        }
        return block;
    }

    public Block newBlock(Class<? extends Block> blockClazz) {
        return this.newBlock(blockClazz.getSimpleName(), (Block)blockClazz);
    }

    public Block newBlock(String name, Class<? extends Block> blockClazz) {
        try {
            return this.newBlock(name, blockClazz.newInstance());
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public <C extends Block> C newBlock(String name, C block) {
        return this.newBlock(name, block, ItemBlock.class);
    }

    public <C extends Block> C newBlock(String name, C block, Class<? extends ItemBlock> itemBlockClass) {
        if (!block.func_149739_a().contains(this.modPrefix)) {
            block.func_149663_c(this.modPrefix + name);
        }
        try {
            Field field = block.getClass().getField("field_149768_d");
            if (field == null) {
                field = block.getClass().getField("textureName");
            }
            field.setAccessible(true);
            if (field.get(block) == null) {
                block.func_149658_d(this.modPrefix + name);
            }
        }
        catch (NoSuchFieldException e) {
            block.func_149658_d(this.modPrefix + name);
        }
        catch (IllegalAccessException e) {
            block.func_149658_d(this.modPrefix + name);
        }
        if (itemBlockClass != null) {
            GameRegistry.registerBlock(block, itemBlockClass, (String)name);
        } else {
            GameRegistry.registerBlock(block, ItemBlockMetadata.class, (String)name);
        }
        return block;
    }

    public <C extends Item> C newItem(Class<C> clazz, Object ... args) {
        return this.newItem(LanguageUtility.decapitalizeFirst(clazz.getSimpleName().replace("Item", "")), clazz, args);
    }

    public <C extends Item> C newItem(String name, Class<C> clazz, Object ... args) {
        try {
            Item item;
            if (args != null && args.length > 0) {
                ArrayList paramTypes = new ArrayList();
                for (Object arg : args) {
                    paramTypes.add(arg.getClass());
                }
                item = (Item)clazz.getConstructor(paramTypes.toArray(new Class[0])).newInstance(new Object[0]);
            } else {
                item = (Item)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return (C)this.newItem(name, item);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Item [" + name + "] failed to be created: " + e.getLocalizedMessage(), e.fillInStackTrace());
        }
    }

    public Item newItem(Item item) {
        try {
            return this.newItem(LanguageUtility.decapitalizeFirst(item.getClass().getSimpleName().replace("Item", "")), item);
        }
        catch (StringIndexOutOfBoundsException e) {
            System.out.println("Item: " + item + "   Class: " + item.getClass());
            throw e;
        }
        catch (IllegalArgumentException e) {
            System.out.println("Item: " + item + "   Class: " + item.getClass());
            throw e;
        }
    }

    public Item newItem(String name, Item item) {
        if (item != null) {
            if (this.modPrefix != null) {
                item.func_77655_b(this.modPrefix + name);
                if (ReflectionHelper.getPrivateValue(Item.class, (Object)item, (String[])new String[]{"iconString", "field_111218_cA"}) == null) {
                    item.func_111206_d(this.modPrefix + name);
                }
            }
            if (this.defaultTab != null) {
                item.func_77637_a(this.defaultTab);
            }
            this.items.put(item, name);
            GameRegistry.registerItem((Item)item, (String)name);
        }
        return item;
    }
}

