/*
 * Decompiled with CFR 0.152.
 */
package resonant.engine;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import resonant.api.IBoilHandler;
import resonant.api.mffs.fortron.FrequencyGridRegistry;
import resonant.api.recipe.MachineRecipes;
import resonant.content.factory.resources.RecipeType;
import resonant.content.factory.resources.ResourceFactoryHandler;
import resonant.content.loader.ModManager;
import resonant.content.wrapper.BlockDummy;
import resonant.engine.CommonProxy;
import resonant.engine.References;
import resonant.engine.content.ItemScrewdriver;
import resonant.engine.content.debug.TileCreativeBuilder;
import resonant.engine.content.debug.TileInfiniteEnergy;
import resonant.engine.content.debug.TileInfiniteFluid;
import resonant.engine.content.tool.ToolMode;
import resonant.engine.content.tool.ToolModeGeneral;
import resonant.engine.content.tool.ToolModeRotation;
import resonant.engine.grid.frequency.FrequencyGrid;
import resonant.engine.grid.thermal.BoilEvent;
import resonant.engine.grid.thermal.EventThermal;
import resonant.engine.grid.thermal.ThermalGrid;
import resonant.lib.config.ConfigHandler;
import resonant.lib.config.ConfigScanner;
import resonant.lib.loadable.LoadableHandler;
import resonant.lib.multiblock.synthetic.SyntheticMultiblock;
import resonant.lib.network.netty.PacketManager;
import resonant.lib.ore.OreGenerator;
import resonant.lib.utility.PlayerInteractionHandler;
import resonant.lib.utility.PotionUtility;
import resonant.lib.utility.nbt.SaveManager;
import universalelectricity.api.core.grid.IUpdate;
import universalelectricity.core.grid.UpdateTicker;
import universalelectricity.core.transform.vector.Vector3;
import universalelectricity.core.transform.vector.VectorWorld;

@Mod(modid="ResonantEngine", name="Resonant Engine", version="@MAJOR@.@MINOR@.@REVIS@", dependencies="required-after:UniversalElectricity")
public class ResonantEngine {
    public static final ModManager contentRegistry = new ModManager().setPrefix("resonant:").setTab(CreativeTabs.field_78040_i);
    public static final boolean runningAsDev = System.getProperty("development") != null && System.getProperty("development").equalsIgnoreCase("true");
    @SidedProxy(clientSide="resonant.engine.ClientProxy", serverSide="resonant.engine.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Metadata(value="ResonantEngine")
    public static ModMetadata metadata;
    @Mod.Instance(value="ResonantEngine")
    public static ResonantEngine instance;
    public static BlockDummy blockCreativeBuilder;
    public static Block blockInfiniteFluid;
    public static Block blockInfiniteEnergy;
    public static Block blockOreCopper;
    public static Block blockOreTin;
    public static Item itemWrench;
    public static Item itemMotor;
    public static Item itemCircuitBasic;
    public static Item itemCircuitAdvanced;
    public static Item itemCircuitElite;
    public static OreGenerator generationOreCopper;
    public static OreGenerator generationOreTin;
    public static ResourceFactoryHandler resourceFactory;
    private static ThermalGrid thermalGrid;
    public final PacketManager packetHandler = new PacketManager("resonantengine");
    private LoadableHandler loadables = new LoadableHandler();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        ConfigScanner.instance().generateSets(evt.getAsmData());
        resourceFactory = new ResourceFactoryHandler();
        References.CONFIGURATION.load();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)proxy);
        this.loadables.applyModule(proxy);
        this.loadables.applyModule(this.packetHandler);
        PotionUtility.resizePotionArray();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)SaveManager.instance());
        MinecraftForge.EVENT_BUS.register((Object)new PlayerInteractionHandler());
        ToolMode.REGISTRY.add(new ToolModeGeneral());
        ToolMode.REGISTRY.add(new ToolModeRotation());
        SyntheticMultiblock.instance = new SyntheticMultiblock();
        if (References.CONFIGURATION.get("Content", "LoadScrewDriver", true).getBoolean(true)) {
            itemWrench = new ItemScrewdriver();
            GameRegistry.registerItem((Item)itemWrench, (String)"screwdriver", (String)"ResonantEngine");
        }
        if (References.CONFIGURATION.get("Content", "LoadParts", true).getBoolean(true)) {
            // empty if block
        }
        if (References.CONFIGURATION.get("Creative Tools", "CreativeBuilder", true).getBoolean(true)) {
            blockCreativeBuilder = contentRegistry.newBlock(TileCreativeBuilder.class, new Object[0]);
        }
        if (References.CONFIGURATION.get("Creative Tools", "InfiniteSource", true).getBoolean(true)) {
            blockInfiniteFluid = contentRegistry.newBlock(TileInfiniteFluid.class, new Object[0]);
            blockInfiniteEnergy = contentRegistry.newBlock(TileInfiniteEnergy.class, new Object[0]);
        }
        References.CONFIGURATION.save();
        this.loadables.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        References.CONFIGURATION.load();
        References.CONFIGURATION.save();
        ResonantEngine.metadata.modId = "Resonant Engine";
        ResonantEngine.metadata.name = "Resonant Engine";
        ResonantEngine.metadata.description = "Resonant Engine is a mod developement framework designed to assist in creation of mods. It provided basic classes for packet handling, tile creation, inventory handling, saving/loading of NBT, and general all around prefabs.";
        ResonantEngine.metadata.url = "https://github.com/Universal-Electricity/Resonant-Engine";
        ResonantEngine.metadata.version = "@MAJOR@.@MINOR@.@REVIS@@BUILD@";
        ResonantEngine.metadata.authorList = Arrays.asList("Calclavia", "DarkCow", "tgame14", "Maxwolf");
        ResonantEngine.metadata.autogenerated = false;
        proxy.init();
        this.loadables.init();
        OreDictionary.registerOre((String)"ingotGold", (Item)Items.field_151043_k);
        OreDictionary.registerOre((String)"ingotIron", (Item)Items.field_151042_j);
        OreDictionary.registerOre((String)"oreGold", (Block)Blocks.field_150352_o);
        OreDictionary.registerOre((String)"oreIron", (Block)Blocks.field_150366_p);
        OreDictionary.registerOre((String)"oreLapis", (Block)Blocks.field_150369_x);
        MachineRecipes.INSTANCE.addRecipe(RecipeType.SMELTER.name(), new FluidStack(FluidRegistry.LAVA, 1000), new ItemStack(Blocks.field_150348_b));
        MachineRecipes.INSTANCE.addRecipe(RecipeType.CRUSHER.name(), Blocks.field_150347_e, Blocks.field_150351_n);
        MachineRecipes.INSTANCE.addRecipe(RecipeType.CRUSHER.name(), Blocks.field_150348_b, Blocks.field_150347_e);
        MachineRecipes.INSTANCE.addRecipe(RecipeType.CRUSHER.name(), Blocks.field_150486_ae, new ItemStack(Blocks.field_150344_f, 7, 0));
        MachineRecipes.INSTANCE.addRecipe(RecipeType.GRINDER.name(), Blocks.field_150347_e, Blocks.field_150354_m);
        MachineRecipes.INSTANCE.addRecipe(RecipeType.GRINDER.name(), Blocks.field_150351_n, Blocks.field_150354_m);
        MachineRecipes.INSTANCE.addRecipe(RecipeType.GRINDER.name(), Blocks.field_150359_w, Blocks.field_150354_m);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        ConfigHandler.sync(References.CONFIGURATION, "resonant");
        UpdateTicker.addUpdater((IUpdate)thermalGrid);
        this.loadables.postInit();
        FrequencyGridRegistry.CLIENT_INSTANCE = new FrequencyGrid();
        FrequencyGridRegistry.SERVER_INSTANCE = new FrequencyGrid();
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        FrequencyGridRegistry.CLIENT_INSTANCE = new FrequencyGrid();
        FrequencyGridRegistry.SERVER_INSTANCE = new FrequencyGrid();
    }

    @Mod.EventHandler
    public void onServerStopping(FMLServerStoppingEvent evt) {
        SaveManager.saveAll();
    }

    @SubscribeEvent
    public void boilEventHandler(BoilEvent evt) {
        World world = evt.world;
        Vector3 position = evt.position;
        Block block = position.getBlock((IBlockAccess)world);
        for (int height = 1; height <= evt.maxSpread; ++height) {
            TileEntity tileEntity = world.func_147438_o(position.xi(), position.yi() + height, position.zi());
            if (!(tileEntity instanceof IBoilHandler)) continue;
            IBoilHandler handler = (IBoilHandler)tileEntity;
            FluidStack fluid = evt.getRemainForSpread(height);
            if (fluid.amount <= 0 || !handler.canFill(ForgeDirection.DOWN, fluid.getFluid())) continue;
            fluid.amount -= handler.fill(ForgeDirection.DOWN, fluid, true);
        }
        evt.setResult(Event.Result.DENY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void thermalEventHandler(EventThermal.EventThermalUpdate evt) {
        final VectorWorld pos = evt.position;
        World world = pos.world();
        synchronized (world) {
            Block block = pos.getBlock();
            Material mat = pos.getBlock().func_149688_o();
            if (mat == Material.field_151579_a) {
                evt.heatLoss = 0.15f;
            }
            if ((block == Blocks.field_150358_i || block == Blocks.field_150355_j) && evt.temperature >= 373.0f) {
                if (FluidRegistry.getFluid((String)"steam") != null) {
                    int volume = (int)(1000.0f * (evt.temperature / 373.0f));
                    MinecraftForge.EVENT_BUS.post((Event)new BoilEvent(pos.world(), (Vector3)pos, new FluidStack(FluidRegistry.WATER, volume), new FluidStack(FluidRegistry.getFluid((String)"steam"), volume), 2, evt.isReactor));
                }
                evt.heatLoss = 0.2f;
            }
            if (block == Blocks.field_150432_aD) {
                if (evt.temperature >= 273.0f) {
                    UpdateTicker.addUpdater((IUpdate)new IUpdate(){

                        public void update(double delta) {
                            pos.setBlock((Block)Blocks.field_150358_i);
                        }

                        public boolean canUpdate() {
                            return true;
                        }

                        public boolean continueUpdate() {
                            return false;
                        }
                    });
                }
                evt.heatLoss = 0.4f;
            }
        }
    }

    static {
        blockOreCopper = null;
        blockOreTin = null;
        itemMotor = null;
        itemCircuitBasic = null;
        itemCircuitAdvanced = null;
        itemCircuitElite = null;
        generationOreCopper = null;
        generationOreTin = null;
        thermalGrid = new ThermalGrid();
    }
}

