/*
 * Decompiled with CFR 0.152.
 */
package resonant.engine.grid.thermal;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import resonant.api.IReactor;
import resonant.engine.ResonantEngine;
import resonant.engine.grid.thermal.EventThermal;
import resonant.engine.grid.thermal.ThermalPhysics;
import universalelectricity.api.core.grid.IUpdate;
import universalelectricity.core.transform.vector.VectorWorld;

public class ThermalGrid
implements IUpdate {
    private static final HashMap<VectorWorld, Float> thermalSource = new HashMap();
    private final float spread = 0.14285715f;
    private final float loss = 0.1f;
    private final float deltaTime = 0.05f;
    private int tick = 0;

    public static float getDefaultTemperature(VectorWorld position) {
        return ThermalPhysics.getTemperatureForCoordinate(position.world(), position.xi(), position.zi());
    }

    public static void addTemperature(VectorWorld position, float deltaTemperature) {
        float defaultTemperature = ThermalGrid.getDefaultTemperature(position);
        float original = thermalSource.containsKey(position) ? thermalSource.get(position).floatValue() : defaultTemperature;
        float newTemperature = original + deltaTemperature;
        if ((double)Math.abs(newTemperature - defaultTemperature) > 0.4) {
            thermalSource.put(position, Float.valueOf(original + deltaTemperature));
        } else {
            thermalSource.remove(position);
        }
    }

    public static float getTemperature(VectorWorld position) {
        if (thermalSource.containsKey(position)) {
            return thermalSource.get(position).floatValue();
        }
        return ThermalPhysics.getTemperatureForCoordinate(position.world(), position.xi(), position.zi());
    }

    public void update(double delta) {
        for (Map.Entry<VectorWorld, Float> entry : new HashMap<VectorWorld, Float>(thermalSource).entrySet()) {
            VectorWorld pos = entry.getKey();
            float currentTemperature = ThermalGrid.getTemperature(pos);
            if (currentTemperature < 0.0f) {
                thermalSource.remove(pos);
                continue;
            }
            float deltaFromEquilibrium = ThermalGrid.getDefaultTemperature(pos) - currentTemperature;
            TileEntity possibleReactor = pos.getTileEntity();
            EventThermal.EventThermalUpdate evt = new EventThermal.EventThermalUpdate(pos, currentTemperature, deltaFromEquilibrium, 0.05f, possibleReactor != null && possibleReactor instanceof IReactor);
            MinecraftForge.EVENT_BUS.post((Event)evt);
            float loss = evt.heatLoss;
            ThermalGrid.addTemperature(pos, (float)(deltaFromEquilibrium > 0.0f ? 1 : -1) * Math.min(Math.abs(deltaFromEquilibrium), Math.abs(loss)));
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                VectorWorld adjacent = pos.clone().$plus(dir);
                float deltaTemperature = ThermalGrid.getTemperature(pos) - ThermalGrid.getTemperature(adjacent);
                Material adjacentMat = adjacent.world().func_147439_a(adjacent.xi(), adjacent.yi(), adjacent.zi()).func_149688_o();
                float spread = (adjacentMat.func_76220_a() ? this.spread : this.spread / 2.0f) * 0.05f;
                if (!(deltaTemperature > 0.0f)) continue;
                ThermalGrid.addTemperature(adjacent, deltaTemperature * spread);
                ThermalGrid.addTemperature(pos, -deltaTemperature * spread);
            }
        }
    }

    public boolean canUpdate() {
        return !ResonantEngine.proxy.isPaused();
    }

    public boolean continueUpdate() {
        return true;
    }
}

