/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.config;

import cpw.mods.fml.common.eventhandler.Event;
import java.lang.reflect.Field;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import resonant.lib.config.Config;
import resonant.lib.config.ConfigEvent;
import resonant.lib.config.ConfigScanner;
import resonant.lib.utility.LanguageUtility;

public final class ConfigHandler {
    public static void sync(Configuration config, String namespace) {
        config.load();
        for (Class clazz : ConfigScanner.instance().classes) {
            if (!clazz.getName().startsWith(namespace)) continue;
            for (Field field : clazz.getDeclaredFields()) {
                Config cfg = field.getAnnotation(Config.class);
                if (cfg == null) continue;
                ConfigHandler.handleField(field, cfg, config);
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)new ConfigEvent.PostConfigEvent(config));
        if (config.hasChanged()) {
            config.save();
        }
    }

    public static void sync(Object obj, Configuration config) {
        config.load();
        for (Field field : obj.getClass().getDeclaredFields()) {
            Config cfg = field.getAnnotation(Config.class);
            if (cfg == null) continue;
            ConfigHandler.handleField(obj, field, cfg, config);
        }
        MinecraftForge.EVENT_BUS.post((Event)new ConfigEvent.PostConfigEvent(config));
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void handleField(Field field, Config cfg, Configuration config) {
        ConfigHandler.handleField(null, field, cfg, config);
    }

    private static void handleField(Object obj, Field field, Config cfg, Configuration config) {
        try {
            String comment;
            field.setAccessible(true);
            String key = cfg.key().isEmpty() ? LanguageUtility.camelToReadable(field.getName()) : cfg.key();
            String string = comment = !cfg.comment().isEmpty() ? cfg.comment() : null;
            if (!field.getType().isArray()) {
                if (field.getType() == Integer.TYPE) {
                    int value = config.get(cfg.category(), key, field.getInt(obj), comment).getInt(field.getInt(obj));
                    field.setInt(obj, value);
                } else if (field.getType() == Double.TYPE) {
                    double value = config.get(cfg.category(), key, field.getDouble(obj), comment).getDouble(field.getDouble(obj));
                    field.setDouble(obj, value);
                } else if (field.getType() == Float.TYPE) {
                    float value = (float)config.get(cfg.category(), key, (double)field.getFloat(obj), comment).getDouble(field.getDouble(obj));
                    field.setFloat(obj, value);
                } else if (field.getType() == String.class) {
                    String value = config.get(cfg.category(), key, (String)field.get(obj), comment).getString();
                    field.set(obj, value);
                } else if (field.getType() == Boolean.TYPE) {
                    boolean value = config.get(cfg.category(), key, field.getBoolean(obj), comment).getBoolean(field.getBoolean(obj));
                    field.setBoolean(obj, value);
                } else if (field.getType() == Long.TYPE) {
                    long value = config.get(cfg.category(), key, (double)field.getLong(obj), comment).getInt();
                    field.setLong(obj, value);
                }
            } else if (field.getType().getComponentType() == String.class) {
                String[] values = config.get(cfg.category(), key, field.get(obj) != null ? (String[])field.get(obj) : new String[]{}, comment).getStringList();
                field.set(obj, values);
            } else if (field.getType().getComponentType() == Integer.TYPE) {
                int[] values = config.get(cfg.category(), key, field.get(obj) != null ? (int[])field.get(obj) : new int[]{}, comment).getIntList();
                field.set(obj, values);
            } else if (field.getType().getComponentType() == Boolean.TYPE) {
                boolean[] values = config.get(cfg.category(), key, field.get(obj) != null ? (boolean[])field.get(obj) : new boolean[]{}, comment).getBooleanList();
                field.set(obj, values);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to sync: " + field.getName());
            e.printStackTrace();
        }
    }
}

