/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.gui;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import resonant.engine.References;
import resonant.lib.gui.ContainerDummy;
import resonant.lib.gui.GuiSlotType;
import resonant.lib.render.RenderUtility;
import resonant.lib.utility.LanguageUtility;
import universalelectricity.api.UnitDisplay;
import universalelectricity.compatibility.module.ModuleThermalExpansion$;
import universalelectricity.core.transform.region.Rectangle;
import universalelectricity.core.transform.vector.Vector2;

public class GuiContainerBase
extends GuiContainer {
    protected static int energyType = 0;
    public ResourceLocation baseTexture;
    public String tooltip = "";
    protected int meterX = 54;
    protected int meterHeight = 49;
    protected int meterWidth = 14;
    protected int meterEnd = this.meterX + this.meterWidth;
    protected HashMap<Rectangle, String> tooltips = new HashMap();
    protected int containerWidth;
    protected int containerHeight;
    private float lastChangeFrameTime;

    public GuiContainerBase(Container container) {
        super(container);
        this.field_147000_g = 217;
        this.baseTexture = References.GUI_BASE;
    }

    public GuiContainerBase() {
        this(new ContainerDummy());
        this.baseTexture = References.GUI_EMPTY_FILE;
    }

    protected void drawString(String str, int x, int y) {
        this.field_146289_q.func_78276_b(str, x, y, 0x404040);
    }

    protected void drawString(String str, int y) {
        this.field_146289_q.func_78276_b(str, this.field_146999_f / 2, y, 0x404040);
    }

    protected void drawStringCentered(String str, int x, int y) {
        this.drawString(str, x - this.field_146289_q.func_78256_a(str) / 2, y);
    }

    protected void drawStringCentered(String str, int y) {
        this.drawStringCentered(str, this.field_146999_f / 2, y);
    }

    protected void drawStringCentered(String str) {
        this.drawStringCentered(str, 6);
    }

    public void func_146281_b() {
        Keyboard.enableRepeatEvents((boolean)false);
        super.func_146281_b();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        for (Map.Entry<Rectangle, String> entry : this.tooltips.entrySet()) {
            if (!entry.getKey().intersects(new Vector2((double)(mouseX - this.field_147003_i), (double)(mouseY - this.field_147009_r)))) continue;
            this.tooltip = entry.getValue();
            break;
        }
        if (this.tooltip != null && this.tooltip != "") {
            this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r, LanguageUtility.splitStringPerWord(this.tooltip, 5).toArray(new String[0]));
        }
        this.tooltip = "";
    }

    protected void func_146976_a(float f, int mouseX, int mouseY) {
        this.containerWidth = (this.field_146294_l - this.field_146999_f) / 2;
        this.containerHeight = (this.field_146295_m - this.field_147000_g) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(this.baseTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth, this.containerHeight, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    protected void drawBulb(int x, int y, boolean isOn) {
        this.field_146297_k.field_71446_o.func_110577_a(this.baseTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (isOn) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 161, 0, 6, 6);
        } else {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 161, 4, 6, 6);
        }
    }

    protected void drawSlot(int x, int y, ItemStack itemStack) {
        this.field_146297_k.field_71446_o.func_110577_a(this.baseTexture);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 0, 18, 18);
        this.drawItemStack(itemStack, this.containerWidth + x, this.containerHeight + y);
    }

    protected void drawItemStack(ItemStack itemStack, int x, int y) {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)32.0f);
        field_146296_j.func_82406_b(this.field_146289_q, this.field_146297_k.field_71446_o, itemStack, ++x, ++y);
    }

    protected void drawTextWithTooltip(String textName, String format, int x, int y, int mouseX, int mouseY) {
        this.drawTextWithTooltip(textName, format, x, y, mouseX, mouseY, 0x404040);
    }

    protected void drawTextWithTooltip(String textName, String format, int x, int y, int mouseX, int mouseY, int color) {
        String name = LanguageUtility.getLocal("gui." + textName + ".name");
        String text = format.replaceAll("%1", name);
        this.field_146289_q.func_78276_b(text, x, y, color);
        String tooltip = LanguageUtility.getLocal("gui." + textName + ".tooltip");
        if (tooltip != null && tooltip != "" && new Rectangle((double)x, (double)y, (double)((int)((double)text.length() * 4.8)), 12.0).intersects(new Vector2((double)mouseX, (double)mouseY))) {
            this.tooltip = tooltip;
        }
    }

    protected void drawTextWithTooltip(String textName, int x, int y, int mouseX, int mouseY) {
        this.drawTextWithTooltip(textName, "%1", x, y, mouseX, mouseY);
    }

    protected void drawSlot(int x, int y, GuiSlotType type, float r, float g, float b) {
        this.field_146297_k.field_71446_o.func_110577_a(References.GUI_COMPONENTS);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 0, 18, 18);
        if (type != GuiSlotType.NONE) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 18 * type.ordinal(), 18, 18);
        }
    }

    protected void drawSlot(int x, int y, GuiSlotType type) {
        this.drawSlot(x, y, type, 1.0f, 1.0f, 1.0f);
    }

    protected void drawSlot(int x, int y) {
        this.drawSlot(x, y, GuiSlotType.NONE);
    }

    protected void drawBar(int x, int y, float scale) {
        this.field_146297_k.field_71446_o.func_110577_a(References.GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 18, 0, 22, 15);
        if (scale > 0.0f) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 18, 15, 22 - (int)(scale * 22.0f), 15);
        }
    }

    protected void drawForce(int x, int y, float scale) {
        this.field_146297_k.field_71446_o.func_110577_a(References.GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 0, 107, 11);
        if (scale > 0.0f) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, this.meterX, 11, (int)(scale * 107.0f), 11);
        }
    }

    protected void drawLongBlueBar(int x, int y, float scale) {
        this.field_146297_k.field_71446_o.func_110577_a(References.GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, this.meterX, 33, 140, 14);
        if (scale > 0.0f) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, this.meterX, 48, (int)(scale * 140.0f), 14);
        }
    }

    protected void drawElectricity(int x, int y, float scale) {
        this.field_146297_k.field_71446_o.func_110577_a(References.GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 0, 107, 11);
        if (scale > 0.0f) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 54, 22, (int)(scale * 107.0f), 11);
        }
    }

    protected void drawMeter(int x, int y, float scale, float r, float g, float b) {
        this.field_146297_k.field_71446_o.func_110577_a(References.GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 0, this.meterWidth, this.meterHeight);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        int actualScale = (int)((float)(this.meterHeight - 1) * scale);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y + (this.meterHeight - 1 - actualScale), 40, 49, this.meterHeight - 1, actualScale);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 98, this.meterWidth, this.meterHeight);
    }

    protected void drawMeter(int x, int y, float scale, FluidStack liquidStack) {
        this.field_146297_k.field_71446_o.func_110577_a(References.GUI_COMPONENTS);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 0, this.meterWidth, this.meterHeight);
        if (liquidStack != null) {
            this.displayGauge(this.containerWidth + x, this.containerHeight + y, -10, 1, 12, (int)((float)(this.meterHeight - 1) * scale), liquidStack);
        }
        this.field_146297_k.field_71446_o.func_110577_a(References.GUI_COMPONENTS);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 40, 98, this.meterWidth, this.meterHeight);
    }

    protected void drawSlot(int x, int y, SlotType type, float r, float g, float b) {
        this.field_146297_k.field_71446_o.func_110577_a(References.GUI_COMPONENTS);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
        this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 0, 18, 18);
        if (type != SlotType.NONE) {
            this.func_73729_b(this.containerWidth + x, this.containerHeight + y, 0, 18 * type.ordinal(), 18, 18);
        }
    }

    protected void drawSlot(int x, int y, SlotType type) {
        this.drawSlot(x, y, type, 1.0f, 1.0f, 1.0f);
    }

    public void renderUniversalDisplay(int x, int y, double energy, int mouseX, int mouseY, UnitDisplay.Unit unit) {
        this.renderUniversalDisplay(x, y, energy, mouseX, mouseY, unit, false);
    }

    public void renderUniversalDisplay(int x, int y, double energy, double maxEnergy, int mouseX, int mouseY, UnitDisplay.Unit unit, boolean symbol) {
        String displaySuffix = "";
        if (unit == UnitDisplay.Unit.WATT) {
            displaySuffix = "/s";
        }
        String display = new UnitDisplay(unit, energy).symbol(symbol) + "/" + new UnitDisplay(unit, maxEnergy).symbol(symbol);
        if (unit == UnitDisplay.Unit.WATT || unit == UnitDisplay.Unit.JOULES) {
            switch (energyType) {
                case 3: {
                    display = UnitDisplay.roundDecimals((double)(energy * ModuleThermalExpansion$.MODULE$.ratio)) + " RF" + displaySuffix + "/" + UnitDisplay.roundDecimals((double)(maxEnergy * ModuleThermalExpansion$.MODULE$.ratio)) + " RF" + displaySuffix;
                }
            }
        }
        if (new Rectangle((double)x, (double)y, (double)(x + display.length() * 5), (double)(y + 9)).intersects(new Vector2((double)mouseX, (double)mouseY))) {
            if (Mouse.isButtonDown((int)0) && this.lastChangeFrameTime <= 0.0f) {
                energyType = (energyType + 1) % 4;
                this.lastChangeFrameTime = 60.0f;
            } else {
                this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r + 10, "Click to change unit.");
            }
        }
        this.lastChangeFrameTime -= 1.0f;
        this.field_146289_q.func_78276_b(display, x, y, 0x404040);
    }

    public void renderUniversalDisplay(int x, int y, double energy, int mouseX, int mouseY, UnitDisplay.Unit unit, boolean small) {
        String displaySuffix = "";
        if (unit == UnitDisplay.Unit.WATT) {
            displaySuffix = "/s";
        }
        String display = new UnitDisplay(unit, energy).symbol(small).toString();
        if (unit == UnitDisplay.Unit.WATT || unit == UnitDisplay.Unit.JOULES) {
            switch (energyType) {
                case 3: {
                    display = UnitDisplay.roundDecimals((double)(energy * ModuleThermalExpansion$.MODULE$.ratio)) + " RF" + displaySuffix;
                }
            }
        }
        if (new Rectangle((double)x, (double)y, (double)(x + display.length() * 5), (double)(y + 9)).intersects(new Vector2((double)mouseX, (double)mouseY))) {
            if (Mouse.isButtonDown((int)0) && this.lastChangeFrameTime <= 0.0f) {
                energyType = (energyType + 1) % 4;
                this.lastChangeFrameTime = 60.0f;
            } else {
                this.drawTooltip(mouseX - this.field_147003_i, mouseY - this.field_147009_r + 10, "Click to change unit.");
            }
        }
        this.lastChangeFrameTime -= 1.0f;
        this.field_146289_q.func_78276_b(display, x, y, 0x404040);
    }

    public void drawTooltip(int x, int y, String ... toolTips) {
        if (!GuiScreen.func_146272_n() && toolTips != null) {
            int var7;
            int var6;
            GL11.glDisable((int)32826);
            GL11.glDisable((int)2929);
            int var5 = 0;
            for (var6 = 0; var6 < toolTips.length; ++var6) {
                var7 = this.field_146289_q.func_78256_a(toolTips[var6]);
                if (var7 <= var5) continue;
                var5 = var7;
            }
            var6 = x + 12;
            var7 = y - 12;
            int var9 = 8;
            if (toolTips.length > 1) {
                var9 += 2 + (toolTips.length - 1) * 10;
            }
            if (this.field_147009_r + var7 + var9 + 6 > this.field_146295_m) {
                var7 = this.field_146295_m - var9 - this.field_147009_r - 6;
            }
            this.field_73735_i = 300.0f;
            int var10 = -267386864;
            this.func_73733_a(var6 - 3, var7 - 4, var6 + var5 + 3, var7 - 3, var10, var10);
            this.func_73733_a(var6 - 3, var7 + var9 + 3, var6 + var5 + 3, var7 + var9 + 4, var10, var10);
            this.func_73733_a(var6 - 3, var7 - 3, var6 + var5 + 3, var7 + var9 + 3, var10, var10);
            this.func_73733_a(var6 - 4, var7 - 3, var6 - 3, var7 + var9 + 3, var10, var10);
            this.func_73733_a(var6 + var5 + 3, var7 - 3, var6 + var5 + 4, var7 + var9 + 3, var10, var10);
            int var11 = 0x505000FF;
            int var12 = (var11 & 0xFEFEFE) >> 1 | var11 & 0xFF000000;
            this.func_73733_a(var6 - 3, var7 - 3 + 1, var6 - 3 + 1, var7 + var9 + 3 - 1, var11, var12);
            this.func_73733_a(var6 + var5 + 2, var7 - 3 + 1, var6 + var5 + 3, var7 + var9 + 3 - 1, var11, var12);
            this.func_73733_a(var6 - 3, var7 - 3, var6 + var5 + 3, var7 - 3 + 1, var11, var11);
            this.func_73733_a(var6 - 3, var7 + var9 + 2, var6 + var5 + 3, var7 + var9 + 3, var12, var12);
            for (int var13 = 0; var13 < toolTips.length; ++var13) {
                String var14 = toolTips[var13];
                this.field_146289_q.func_78261_a(var14, var6, var7, -1);
                var7 += 10;
            }
            this.field_73735_i = 0.0f;
            GL11.glEnable((int)2929);
            GL11.glEnable((int)32826);
        }
    }

    protected void displayGauge(int j, int k, int line, int col, int width, int squaled, FluidStack liquid) {
        block5: {
            int x;
            --squaled;
            if (liquid == null) {
                return;
            }
            int start = 0;
            IIcon liquidIcon = null;
            Fluid fluid = liquid.getFluid();
            if (fluid != null && fluid.getStillIcon() != null) {
                liquidIcon = fluid.getStillIcon();
            }
            RenderUtility.setSpriteTexture(fluid.getSpriteNumber());
            if (liquidIcon == null) break block5;
            do {
                if (squaled > 16) {
                    x = 16;
                    squaled -= 16;
                } else {
                    x = squaled;
                    squaled = 0;
                }
                this.func_94065_a(j + col, k + line + 58 - x - start, liquidIcon, width, 16 - (16 - x));
                start += 16;
            } while (x != 0 && squaled != 0);
        }
    }

    public static enum SlotType {
        NONE,
        BATTERY,
        LIQUID,
        GAS,
        ARR_UP,
        ARR_DOWN,
        ARR_LEFT,
        ARR_RIGHT,
        ARR_UP_RIGHT,
        ARR_UP_LEFT,
        ARR_DOWN_LEFT,
        ARR_DOWN_RIGHT;

    }
}

