/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.multiblock.synthetic;

import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import resonant.content.spatial.block.SpatialBlock;
import resonant.content.spatial.block.SpatialTile;
import resonant.engine.ResonantEngine;
import resonant.lib.multiblock.reference.IMultiBlock;
import resonant.lib.multiblock.synthetic.SyntheticMultiblock;
import resonant.lib.network.discriminator.PacketTile;
import resonant.lib.network.discriminator.PacketType;
import resonant.lib.network.handle.IPacketReceiver;
import universalelectricity.core.transform.AbstractOperation;
import universalelectricity.core.transform.vector.Vector3;

public class TileSyntheticPart
extends SpatialTile
implements IPacketReceiver {
    private Vector3 mainBlockPosition;

    public TileSyntheticPart() {
        super(Material.field_76233_E);
        this.blockHardness(0.8f);
        this.normalRender(false);
        this.isOpaqueCube(false);
    }

    public Vector3 getMainBlock() {
        if (this.mainBlockPosition != null) {
            return (Vector3)this.asVector3().add((AbstractOperation)this.mainBlockPosition);
        }
        return null;
    }

    public void setMainBlock(Vector3 mainBlock) {
        this.mainBlockPosition = (Vector3)mainBlock.clone().add(this.asVector3().multiply(-1.0));
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    public IIcon getIcon(IBlockAccess access, int side) {
        try {
            Vector3 main = ((TileSyntheticPart)access.func_147438_o(this.xi(), this.yi(), this.zi())).getMainBlock();
            Block block = main.getBlock(access);
            if (block != null) {
                return block.func_149673_e(access, main.xi(), main.yi(), main.zi(), side);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void onRemove(Block block, int par6) {
        TileEntity tileEntity;
        if (this.getMainBlock() != null && (tileEntity = this.getMainBlock().getTileEntity((IBlockAccess)this.field_145850_b)) instanceof IMultiBlock) {
            SyntheticMultiblock.instance.destroy((IMultiBlock)tileEntity);
        }
    }

    @Override
    public boolean activate(EntityPlayer player, int side, Vector3 hit) {
        TileEntity tileEntity;
        if (this.getMainBlock() != null && (tileEntity = this.getMainBlock().getTileEntity((IBlockAccess)this.field_145850_b)) instanceof SpatialBlock) {
            return ((SpatialBlock)tileEntity).activate(player, side, hit);
        }
        return false;
    }

    @Override
    public int quantityDropped(int meta, int fortune) {
        return 0;
    }

    public Packet func_145844_m() {
        if (this.mainBlockPosition != null) {
            PacketTile packetTile = new PacketTile(this, this.mainBlockPosition.xi(), this.mainBlockPosition.yi(), this.mainBlockPosition.zi());
            return ResonantEngine.instance.packetHandler.toMCPacket(packetTile);
        }
        return null;
    }

    @Override
    public void read(ByteBuf data, EntityPlayer player, PacketType packet) {
        try {
            this.mainBlockPosition = new Vector3((double)data.readInt(), (double)data.readInt(), (double)data.readInt());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_74764_b("mainBlockPosition")) {
            this.mainBlockPosition = new Vector3(nbt.func_74775_l("mainBlockPosition"));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.mainBlockPosition != null) {
            nbt.func_74782_a("mainBlockPosition", (NBTBase)this.mainBlockPosition.toNBT());
        }
    }

    public boolean canUpdate() {
        return false;
    }
}

