/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.network.discriminator;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import resonant.engine.References;
import resonant.engine.ResonantEngine;
import resonant.lib.network.discriminator.PacketAnnotationManager;
import resonant.lib.network.discriminator.PacketType;
import resonant.lib.network.handle.TPacketReceiver;
import resonant.lib.network.netty.PacketManager;

public class PacketAnnotation
extends PacketType {
    protected int classID;
    protected int packetSetID;

    public PacketAnnotation() {
    }

    public PacketAnnotation(Object obj) {
        this(obj, 0);
    }

    public PacketAnnotation(Object obj, int packetSetID) {
        PacketAnnotationManager.PacketSet packetSet;
        PacketAnnotationManager.INSTANCE.constructPacketSets(obj.getClass());
        int classID = (Integer)PacketAnnotationManager.INSTANCE.classPacketIDMap.get(obj.getClass());
        if (PacketAnnotationManager.INSTANCE.packetSetIDMap.size() > classID && (packetSet = PacketAnnotationManager.INSTANCE.packetSetIDMap.get(classID).get(packetSetID)) != null) {
            this.classID = classID;
            this.packetSetID = packetSetID;
            if (obj instanceof TileEntity) {
                PacketManager cfr_ignored_0 = ResonantEngine.instance.packetHandler;
                PacketManager.writeData(this.data(), ((TileEntity)obj).field_145851_c, ((TileEntity)obj).field_145848_d, ((TileEntity)obj).field_145849_e);
            }
            this.data().writeBytes(packetSet.getPacketArrayData(obj));
        }
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.classID);
        buffer.writeInt(this.packetSetID);
        buffer.writeBytes(this.data());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.classID = buffer.readInt();
        this.packetSetID = buffer.readInt();
        this.data_$eq(buffer.slice());
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        try {
            Class clazz = PacketAnnotationManager.INSTANCE.getClassForId(this.classID);
            if (clazz != null) {
                if (TileEntity.class.isAssignableFrom(clazz)) {
                    int x = this.data().readInt();
                    int y = this.data().readInt();
                    int z = this.data().readInt();
                    TileEntity tile = player.func_130014_f_().func_147438_o(x, y, z);
                    if (tile != null) {
                        if (tile instanceof TPacketReceiver) {
                            ((TPacketReceiver)tile).read(this.data(), player, this);
                        } else {
                            PacketAnnotationManager.INSTANCE.getSet(clazz, this.packetSetID).read(tile, this.data().slice());
                        }
                    } else {
                        References.LOGGER.error("Sent Annotation packet to null Tile: " + x + " : " + y + " : " + z);
                    }
                } else {
                    References.LOGGER.fatal("PacketAnnotation: Unsupported class type " + clazz);
                }
            } else {
                References.LOGGER.fatal("PacketAnnotation: Unknown classID " + this.classID);
            }
        }
        catch (Exception e) {
            References.LOGGER.fatal("Failed to read Annotation Packet", (Throwable)e);
            throw new UnsupportedOperationException(e);
        }
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        try {
            if (TileEntity.class.isAssignableFrom((Class)PacketAnnotationManager.INSTANCE.classPacketIDMap.inverse().get((Object)this.classID))) {
                int x = this.data().readInt();
                int y = this.data().readInt();
                int z = this.data().readInt();
                TileEntity tile = player.func_130014_f_().func_147438_o(x, y, z);
                if (tile != null) {
                    PacketAnnotationManager.INSTANCE.packetSetIDMap.get(this.classID).get(this.packetSetID).read(tile, this.data().slice());
                    if (tile instanceof TPacketReceiver) {
                        ((TPacketReceiver)tile).read(this.data(), player, this);
                    }
                } else {
                    References.LOGGER.error("Sent Annotation packet to null Tile: " + x + " : " + y + " : " + z);
                }
            }
        }
        catch (Exception e) {
            References.LOGGER.fatal("Failed to read Annotation Packet", (Throwable)e);
            throw new UnsupportedOperationException(e);
        }
    }
}

