/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.network.discriminator;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidTank;
import resonant.engine.References;
import resonant.engine.ResonantEngine;
import resonant.lib.network.Synced;
import resonant.lib.network.discriminator.PacketAnnotation;
import resonant.lib.network.netty.PacketManager;
import resonant.lib.utility.nbt.ISaveObj;
import universalelectricity.core.transform.vector.Vector3;

public class PacketAnnotationManager {
    public static final PacketAnnotationManager INSTANCE = new PacketAnnotationManager();
    protected final BiMap<Class, Integer> classPacketIDMap = HashBiMap.create();
    protected final HashMap<Integer, HashMap<Integer, PacketSet>> packetSetIDMap = new HashMap();
    private int maxID = 0;

    private PacketAnnotationManager() {
    }

    public void register(Class<? extends TileEntity> clazz) {
        this.constructPacketSets(clazz);
    }

    public void constructPacketSets(Class clazz) {
        if (this.classPacketIDMap.containsKey(clazz)) {
            return;
        }
        int classID = ++this.maxID;
        this.classPacketIDMap.put(clazz, (Object)classID);
        HashMap<Integer, PacketSet> packetSets = new HashMap<Integer, PacketSet>();
        while (clazz != null) {
            PacketSet packetSet;
            Annotation sync;
            for (Field field : clazz.getDeclaredFields()) {
                if (!field.isAnnotationPresent(Synced.class)) continue;
                sync = field.getAnnotation(Synced.class);
                for (int packetID : sync.value()) {
                    packetSet = packetSets.containsKey(packetID) ? (PacketSet)packetSets.get(packetID) : new PacketSet(packetID);
                    packetSet.syncFields.add(field);
                    packetSets.put(packetID, packetSet);
                }
            }
            for (AccessibleObject accessibleObject : clazz.getDeclaredMethods()) {
                if (accessibleObject.isAnnotationPresent(Synced.SyncedInput.class)) {
                    sync = ((Method)accessibleObject).getAnnotation(Synced.SyncedInput.class);
                    for (int packetID : sync.value()) {
                        packetSet = packetSets.containsKey(packetID) ? (PacketSet)packetSets.get(packetID) : new PacketSet(packetID);
                        packetSet.syncInputs.add((Method)accessibleObject);
                        packetSets.put(packetID, packetSet);
                    }
                }
                if (!accessibleObject.isAnnotationPresent(Synced.SyncedOutput.class)) continue;
                sync = ((Method)accessibleObject).getAnnotation(Synced.SyncedOutput.class);
                for (int packetID : sync.value()) {
                    packetSet = packetSets.containsKey(packetID) ? (PacketSet)packetSets.get(packetID) : new PacketSet(packetID);
                    packetSet.syncOutputs.add((Method)accessibleObject);
                    packetSets.put(packetID, packetSet);
                }
            }
            clazz = clazz.getSuperclass();
        }
        this.packetSetIDMap.put(classID, packetSets);
    }

    public void sync(Object obj, int packetSetID) {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            ResonantEngine.instance.packetHandler.sendToAll(new PacketAnnotation(obj, packetSetID));
        } else {
            ResonantEngine.instance.packetHandler.sendToServer(new PacketAnnotation(obj, packetSetID));
        }
    }

    public PacketSet getSet(int clazzId, int packetSetId) {
        HashMap<Integer, PacketSet> map;
        if (this.packetSetIDMap.containsKey(clazzId) && (map = this.packetSetIDMap.get(clazzId)) != null && map.containsKey(packetSetId)) {
            return map.get(packetSetId);
        }
        return null;
    }

    public PacketSet getSet(Class clazz, int packetSetId) {
        if (this.classPacketIDMap.containsKey((Object)clazz)) {
            return this.getSet((Integer)this.classPacketIDMap.get((Object)clazz), packetSetId);
        }
        return null;
    }

    public boolean isAnnotationClass(Class clazz) {
        return this.classPacketIDMap.containsKey((Object)clazz);
    }

    public Class getClassForId(int classId) {
        return this.classPacketIDMap.inverse().containsKey((Object)classId) ? (Class)this.classPacketIDMap.inverse().get((Object)classId) : null;
    }

    public static class PacketSet {
        public final int id;
        public final List<Field> syncFields = new ArrayList<Field>();
        public final List<Method> syncInputs = new ArrayList<Method>();
        public final List<Method> syncOutputs = new ArrayList<Method>();

        public PacketSet(int id) {
            this.id = id;
        }

        public ByteBuf getPacketArrayData(Object obj) {
            ByteBuf data = Unpooled.buffer();
            try {
                for (Field f : this.syncFields) {
                    f.setAccessible(true);
                    Class<?> type = f.getType();
                    Object syncObj = f.get(obj);
                    if (!type.isPrimitive()) {
                        if (syncObj == null) {
                            data.writeBoolean(false);
                            continue;
                        }
                        data.writeBoolean(true);
                        PacketManager cfr_ignored_0 = ResonantEngine.instance.packetHandler;
                        PacketManager.writeData(data, syncObj);
                        continue;
                    }
                    PacketManager cfr_ignored_1 = ResonantEngine.instance.packetHandler;
                    PacketManager.writeData(data, syncObj);
                }
                for (Method m : this.syncOutputs) {
                    m.setAccessible(true);
                    NBTTagCompound nbt = new NBTTagCompound();
                    m.invoke(obj, nbt);
                    ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)nbt);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return data;
        }

        public void read(Object obj, ByteBuf data) {
            try {
                for (Field f : this.syncFields) {
                    f.setAccessible(true);
                    Class<?> type = f.getType();
                    Object result = null;
                    if (type.isPrimitive()) {
                        if (type == Integer.class || type == Integer.TYPE) {
                            result = data.readInt();
                        } else if (type == Float.class || type == Float.TYPE) {
                            result = Float.valueOf(data.readFloat());
                        } else if (type == Double.class || type == Double.TYPE) {
                            result = data.readDouble();
                        } else if (type == Byte.class || type == Byte.TYPE) {
                            result = data.readByte();
                        } else if (type == Boolean.class || type == Boolean.TYPE) {
                            result = data.readBoolean();
                        } else if (type == Short.class || type == Short.TYPE) {
                            result = data.readShort();
                        } else if (type == Long.class || type == Long.TYPE) {
                            result = data.readLong();
                        }
                        if (result == null) {
                            References.LOGGER.fatal("Calclavia packet read a null field for " + obj.getClass().getSimpleName());
                        }
                    } else if (data.readBoolean()) {
                        if (type == String.class) {
                            result = ByteBufUtils.readUTF8String((ByteBuf)data);
                        } else if (type == Vector3.class) {
                            result = new Vector3(data.readDouble(), data.readDouble(), data.readDouble());
                        } else if (type == NBTTagCompound.class) {
                            result = ByteBufUtils.readTag((ByteBuf)data);
                        } else if (type == FluidTank.class) {
                            result = new FluidTank(data.readInt()).readFromNBT(ByteBufUtils.readTag((ByteBuf)data));
                        } else if (ISaveObj.class.isAssignableFrom(type)) {
                            result = f.get(obj);
                            ((ISaveObj)result).load(ByteBufUtils.readTag((ByteBuf)data));
                        }
                    } else {
                        result = null;
                    }
                    f.set(obj, result);
                }
                for (Method m : this.syncInputs) {
                    m.setAccessible(true);
                    m.invoke(obj, ByteBufUtils.readTag((ByteBuf)data));
                }
            }
            catch (Exception e) {
                References.LOGGER.fatal("Resonant Engine annotation packet failed for " + obj.getClass().getSimpleName());
                e.printStackTrace();
            }
        }
    }
}

