/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.network.discriminator;

import cpw.mods.fml.common.network.ByteBufUtils;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.tileentity.TileEntity;
import resonant.lib.network.discriminator.PacketTile;
import universalelectricity.api.core.grid.INode;
import universalelectricity.api.core.grid.INodeProvider;
import universalelectricity.core.transform.vector.IVector3;

public class PacketNode
extends PacketTile {
    public String nodeClassName = "INode";

    public PacketNode() {
    }

    public PacketNode(int x, int y, int z, Object ... args) {
        super(x, y, z, args);
    }

    public PacketNode(TileEntity tile, Object ... args) {
        super(tile, args);
    }

    public PacketNode(INode node, Object ... args) {
        INodeProvider provider = node.getParent();
        this.nodeClassName = node.getClass().getSimpleName();
        if (node instanceof IVector3) {
            this.x = (int)((IVector3)node).x();
            this.y = (int)((IVector3)node).y();
            this.z = (int)((IVector3)node).z();
        } else if (provider instanceof TileEntity) {
            this.x = ((TileEntity)provider).field_145851_c;
            this.y = ((TileEntity)provider).field_145848_d;
            this.z = ((TileEntity)provider).field_145849_e;
        } else if (provider instanceof IVector3) {
            this.x = (int)((IVector3)provider).x();
            this.y = (int)((IVector3)provider).y();
            this.z = (int)((IVector3)provider).z();
        } else {
            throw new IllegalArgumentException("PacketNode needs location date from node: " + node);
        }
        this.write(args);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)this.nodeClassName);
        buffer.writeBytes(this.data());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.nodeClassName = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.data_$eq(buffer.slice());
    }
}

