/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.network.discriminator;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import resonant.lib.network.discriminator.PacketType;
import resonant.lib.network.handle.IPacketIDReceiver;
import resonant.lib.network.handle.IPacketReceiver;
import universalelectricity.core.transform.vector.Vector3;

public class PacketTile
extends PacketType {
    public int x;
    public int y;
    public int z;

    public PacketTile() {
    }

    public PacketTile(int x, int y, int z, Object ... args) {
        super(args);
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public PacketTile(TileEntity tile, Object ... args) {
        this(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e, args);
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeBytes(this.data());
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.data_$eq(buffer.slice());
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
        this.handle(player);
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        this.handle(player);
    }

    public void handle(EntityPlayer player) {
        TileEntity tile = player.func_130014_f_().func_147438_o(this.x, this.y, this.z);
        if (tile instanceof IPacketIDReceiver) {
            try {
                int id;
                IPacketIDReceiver receiver = (IPacketIDReceiver)player.func_130014_f_().func_147438_o(this.x, this.y, this.z);
                ByteBuf buf = this.data().slice();
                try {
                    id = buf.readInt();
                }
                catch (IndexOutOfBoundsException ex) {
                    System.out.println("Packet sent to a Tile[" + tile + "] failed to provide a packet ID");
                    System.out.println("Location: " + new Vector3((double)this.x, (double)this.y, (double)this.z));
                    return;
                }
                receiver.read(buf, id, player, this);
            }
            catch (Exception e) {
                System.out.println("Packet sent to a TileEntity failed to be received [" + tile + "] in " + new Vector3((double)this.x, (double)this.y, (double)this.z));
                e.printStackTrace();
            }
        } else if (tile instanceof IPacketReceiver) {
            try {
                IPacketReceiver receiver = (IPacketReceiver)player.func_130014_f_().func_147438_o(this.x, this.y, this.z);
                receiver.read(this.data().slice(), player, this);
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println("Packet sent to a TileEntity was read out side its bounds [" + tile + "] in " + new Vector3((double)this.x, (double)this.y, (double)this.z));
            }
            catch (Exception e) {
                System.out.println("Packet sent to a TileEntity failed to be received [" + tile + "] in " + new Vector3((double)this.x, (double)this.y, (double)this.z));
                e.printStackTrace();
            }
        } else {
            System.out.println("Packet was sent to a tile not implementing IPacketReceiver, this is a coding error [" + tile + "] in " + new Vector3((double)this.x, (double)this.y, (double)this.z));
        }
    }
}

