/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.prefab.fluid;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import resonant.api.recipe.IFluidRecipeCrafter;
import resonant.lib.prefab.fluid.FluidRecipeInfo;
import resonant.lib.type.Pair;
import resonant.lib.type.Triple;
import resonant.lib.utility.FluidUtility;

public class FluidMixtureRegistry {
    public static HashMap<Pair<Object, Object>, Object> fluidMergeResults = new HashMap();

    public static void registerRecipe(Object a, Object b, Object c) {
        if (a != null && b != null && c != null) {
            FluidMixtureRegistry.registerFluidRecipe(new FluidRecipeInfo.SimpleFluidRecipe(a, b, c));
        }
    }

    public static void registerFluidRecipe(FluidRecipeInfo.SimpleFluidRecipe recipe) {
        if (recipe != null && recipe.recipeObjectA != null && recipe.recipeObjectB != null && recipe.recipeObjectC != null) {
            if (!fluidMergeResults.containsKey(new Pair<Object, Object>(recipe.recipeObjectA, recipe.recipeObjectB))) {
                fluidMergeResults.put(new Pair<Object, Object>(recipe.recipeObjectA, recipe.recipeObjectB), recipe);
            }
            if (recipe.canBeReversed && !fluidMergeResults.containsKey(new Pair<Object, Object>(recipe.recipeObjectB, recipe.recipeObjectA))) {
                fluidMergeResults.put(new Pair<Object, Object>(recipe.recipeObjectB, recipe.recipeObjectA), recipe);
            }
        }
    }

    public static void loadPotionRecipes() {
    }

    public static void craft(IFluidRecipeCrafter crafter) {
        Object received = crafter.getReceivingObjectStack();
        int receivedVolume = 0;
        Object input = crafter.getInputObjectStack();
        int inputVolume = 0;
        if (crafter != null && received != null && input != null) {
            if (received instanceof FluidStack) {
                receivedVolume = ((FluidStack)received).amount;
                received = FluidUtility.getStack((FluidStack)received, 1);
            }
            if (received instanceof ItemStack) {
                receivedVolume = ((ItemStack)received).field_77994_a;
                ((ItemStack)received).field_77994_a = 1;
            }
            if (input instanceof FluidStack) {
                inputVolume = ((FluidStack)input).amount;
                input = FluidUtility.getStack((FluidStack)input, 1);
            }
            if (input instanceof ItemStack) {
                receivedVolume = ((ItemStack)input).field_77994_a;
                ((ItemStack)input).field_77994_a = 1;
            }
            Boolean result = fluidMergeResults.containsKey(new Pair<Object, Object>(crafter.getReceivingObjectStack(), crafter.getInputObjectStack()));
            if (received instanceof FluidStack) {
                ((FluidStack)received).amount = receivedVolume;
            }
            if (received instanceof ItemStack) {
                ((ItemStack)received).field_77994_a = receivedVolume;
            }
            if (input instanceof FluidStack) {
                ((FluidStack)input).amount = inputVolume;
            }
            if (input instanceof ItemStack) {
                ((ItemStack)input).field_77994_a = inputVolume;
            }
            if (result != null && result instanceof FluidRecipeInfo.SimpleFluidRecipe) {
                Triple<Integer, Integer, Pair<Object, Integer>> re = ((FluidRecipeInfo.SimpleFluidRecipe)((Object)result)).mix(crafter.getInputObjectStack(), crafter.getInputObjectStack());
                crafter.setRecipeObjectContent(received, re.getA(), input, re.getB(), re.getC().left(), re.getC().right());
            }
            crafter.setRecipeObjectContent(received, 0, input, 0, result, 0);
        }
    }

    public static FluidStack mergeFluidStacks(FluidStack stackOne, FluidStack stackTwo) {
        FluidStack resultStack = null;
        if (stackTwo != null && stackOne != null && stackOne.isFluidEqual(stackTwo)) {
            resultStack = stackOne.copy();
            resultStack.amount += stackTwo.amount;
        } else if (stackOne == null && stackTwo != null) {
            resultStack = stackTwo.copy();
        } else if (stackOne != null && stackTwo == null) {
            resultStack = stackOne.copy();
        } else if (stackTwo != null && stackOne != null && !stackOne.isFluidEqual(stackTwo)) {
            System.out.println("preforming fluid merge event");
            Object result = fluidMergeResults.get(new Pair<Fluid, Fluid>(stackOne.getFluid(), stackTwo.getFluid()));
            if (result != null) {
                System.out.println("result = " + result.toString());
                if (result instanceof Fluid) {
                    resultStack = new FluidStack(((Fluid)result).getID(), stackOne.amount + stackTwo.amount);
                } else if (result instanceof FluidStack) {
                    resultStack = ((FluidStack)result).copy();
                    resultStack.amount = stackOne.amount + stackTwo.amount;
                } else if (result instanceof String && ((String)result).startsWith("Liquid:")) {
                    resultStack = new FluidStack(FluidRegistry.getFluid((String)((String)result).replace("Liquid:", "")), stackOne.amount + stackTwo.amount);
                } else if (result instanceof FluidRecipeInfo.SimpleFluidRecipe) {
                    Triple<Integer, Integer, Pair<Object, Integer>> re = ((FluidRecipeInfo.SimpleFluidRecipe)result).mix(stackOne, stackTwo);
                    if (re.getC().left() instanceof FluidStack) {
                        resultStack = FluidUtility.getStack((FluidStack)re.getC().left(), re.getC().right());
                    } else if (re.getC().left() instanceof FluidStack) {
                        resultStack = new FluidStack((Fluid)re.getC().left(), re.getC().right().intValue());
                    }
                }
            }
            if (resultStack == null) {
                System.out.println("Merging fluids into a waste fluid stack");
                Fluid waste = FluidRegistry.getFluid((String)"waste");
                if (waste == null) {
                    System.out.println("[FluidNetworkHelper] Attempted to merge two fluids into a waste fluid stack but Forge fluid registry return null for waste. Possible that waste fluid was disabled or not registered correctly.");
                    return null;
                }
                if (stackTwo.fluidID == waste.getID() && stackOne.fluidID == waste.getID()) {
                    ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
                    stacks.addAll(FluidMixtureRegistry.getStacksFromWaste(stackOne.copy()));
                    stacks.addAll(FluidMixtureRegistry.getStacksFromWaste(stackTwo.copy()));
                    resultStack = FluidMixtureRegistry.createNewWasteStack(stacks.toArray(new FluidStack[stacks.size()]));
                } else {
                    resultStack = FluidMixtureRegistry.createNewWasteStack(stackOne.copy(), stackTwo.copy());
                }
            }
        }
        return resultStack;
    }

    public static List<FluidStack> getStacksFromWaste(FluidStack wasteStack) {
        ArrayList<FluidStack> stacks = new ArrayList<FluidStack>();
        if (wasteStack.fluidID == FluidRegistry.getFluidID((String)"waste")) {
            for (int i = 1; i <= wasteStack.tag.func_74762_e("liquids"); ++i) {
                FluidStack readStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)wasteStack.tag.func_74775_l("Liquid" + i));
                if (readStack == null) continue;
                stacks.add(readStack);
            }
        }
        return stacks;
    }

    public static FluidStack createNewWasteStack(FluidStack ... liquids) {
        FluidStack stack = new FluidStack(FluidRegistry.getFluid((String)"waste"), 0);
        stack.tag = new NBTTagCompound();
        if (liquids != null) {
            int count = 0;
            for (int i = 0; i < liquids.length; ++i) {
                if (liquids[i] == null) continue;
                if (!liquids[i].getFluid().equals(stack.getFluid())) {
                    stack.tag.func_74782_a("Liquids" + ++count, (NBTBase)liquids[i].writeToNBT(new NBTTagCompound()));
                    stack.amount += liquids[i].amount;
                    continue;
                }
                for (FluidStack loadStack : FluidMixtureRegistry.getStacksFromWaste(liquids[i])) {
                    stack.tag.func_74782_a("Liquids" + ++count, (NBTBase)loadStack.writeToNBT(new NBTTagCompound()));
                    stack.amount += loadStack.amount;
                }
            }
            stack.tag.func_74768_a("liquids", count);
        }
        return stack;
    }

    public static Object getMergeResult(FluidStack stackOne, FluidStack stackTwo) {
        FluidStack sampleStackTwo;
        FluidStack sampleStackOne;
        if (stackOne != null && stackTwo != null && !stackOne.equals((Object)stackTwo) && fluidMergeResults.containsKey(new Pair<FluidStack, FluidStack>(sampleStackOne = FluidUtility.getStack(stackOne, 1), sampleStackTwo = FluidUtility.getStack(stackTwo, 1)))) {
            return fluidMergeResults.get(new Pair<FluidStack, FluidStack>(sampleStackOne, sampleStackTwo));
        }
        return null;
    }

    static {
        FluidMixtureRegistry.registerRecipe(FluidRegistry.LAVA, FluidRegistry.WATER, Blocks.field_150343_Z);
        FluidMixtureRegistry.registerRecipe(FluidRegistry.WATER, FluidRegistry.LAVA, Blocks.field_150347_e);
    }
}

