/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.render;

import java.awt.Color;
import net.minecraft.util.StatCollector;

public enum EnumColor {
    BLACK("\u00a70", "black", new int[]{0, 0, 0}, 0),
    DARK_BLUE("\u00a71", "darkBlue", new int[]{0, 0, 170}, 4),
    DARK_GREEN("\u00a72", "darkGreen", new int[]{0, 170, 0}, 2),
    DARK_AQUA("\u00a73", "darkAqua", new int[]{0, 170, 170}, 6),
    DARK_RED("\u00a74", "darkRed", new int[]{170, 0, 0}, 1),
    PURPLE("\u00a75", "purple", new int[]{170, 0, 170}, 5),
    ORANGE("\u00a76", "orange", new int[]{255, 170, 0}, 14),
    GREY("\u00a77", "grey", new int[]{170, 170, 170}, 7),
    DARK_GREY("\u00a78", "darkGrey", new int[]{85, 85, 85}, 8),
    INDIGO("\u00a79", "indigo", new int[]{85, 85, 255}, 12),
    BRIGHT_GREEN("\u00a7a", "brightGreen", new int[]{85, 255, 85}, 10),
    AQUA("\u00a7b", "aqua", new int[]{85, 255, 255}, -1),
    RED("\u00a7c", "red", new int[]{255, 85, 85}, 13),
    PINK("\u00a7d", "pink", new int[]{255, 85, 255}, 9),
    YELLOW("\u00a7e", "yellow", new int[]{255, 255, 85}, 11),
    WHITE("\u00a7f", "white", new int[]{255, 255, 255}, 15);

    public static EnumColor[] DYES;
    public final String code;
    public final int[] rgbCode;
    public final int mcMeta;
    public String unlocalizedName;

    private EnumColor(String s, String n2, int[] rgb, int meta) {
        this.code = s;
        this.unlocalizedName = n2;
        this.rgbCode = rgb;
        this.mcMeta = meta;
    }

    public String getLocalizedName() {
        return StatCollector.func_74838_a((String)("color." + this.unlocalizedName));
    }

    public String getName() {
        return this.code + this.getLocalizedName();
    }

    public float getColor(int index) {
        return (float)this.rgbCode[index] / 255.0f;
    }

    public int getMetaValue() {
        return this.mcMeta;
    }

    public Color toColor() {
        return new Color(this.rgbCode[0], this.rgbCode[1], this.rgbCode[2]);
    }

    public String toString() {
        return this.code;
    }

    static {
        DYES = new EnumColor[]{BLACK, DARK_RED, DARK_GREEN, null, DARK_BLUE, PURPLE, DARK_AQUA, GREY, DARK_GREY, PINK, BRIGHT_GREEN, YELLOW, INDIGO, RED, ORANGE, WHITE};
    }
}

