/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.render;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import org.lwjgl.opengl.GL11;
import resonant.lib.render.RenderUtility;

public class FluidRenderUtility {
    public static final int DISPLAY_STAGES = 100;
    private static Map<Fluid, int[]> flowingRenderCache = new HashMap<Fluid, int[]>();
    private static Map<Fluid, int[]> stillRenderCache = new HashMap<Fluid, int[]>();

    public static ResourceLocation getFluidSheet(FluidStack fluidStack) {
        return FluidRenderUtility.getFluidSheet(fluidStack.getFluid());
    }

    public static ResourceLocation getFluidSheet(Fluid fluid) {
        return RenderUtility.getSpriteTexture(fluid.getSpriteNumber());
    }

    public static IIcon getFluidTexture(Fluid fluid, boolean flowing) {
        IIcon icon;
        if (fluid == null) {
            return null;
        }
        IIcon iIcon = icon = flowing ? fluid.getFlowingIcon() : fluid.getStillIcon();
        if (icon == null) {
            icon = ((TextureMap)Minecraft.func_71410_x().func_110434_K().func_110581_b(TextureMap.field_110575_b)).func_110572_b("missingno");
        }
        return icon;
    }

    public static void setColorForFluidStack(FluidStack fluidstack) {
        if (fluidstack == null) {
            return;
        }
        int color = fluidstack.getFluid().getColor(fluidstack);
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
    }

    public static void renderFluidTesselation(IFluidTank tank, double ySouthEast, double yNorthEast, double ySouthWest, double yNorthWest) {
        FluidStack fluidStack = tank.getFluid();
        if (fluidStack != null && fluidStack.amount > 0) {
            GL11.glPushMatrix();
            GL11.glDisable((int)2896);
            Fluid fluid = fluidStack.getFluid();
            IIcon texture = fluid.getStillIcon();
            RenderUtility.bind(FluidRenderUtility.getFluidSheet(fluid));
            int color = fluid.getColor(fluidStack);
            Tessellator t = Tessellator.field_78398_a;
            double uMin = texture.func_94214_a(0.0);
            double uMax = texture.func_94214_a(16.0);
            double vMin = texture.func_94207_b(0.0);
            double vMax = texture.func_94207_b(16.0);
            double vHeight = vMax - vMin;
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(0.5, -0.5, -0.5, uMax, vMin);
            t.func_78374_a(-0.5, -0.5, -0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMin, vMin + vHeight * yNorthWest);
            t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMax, vMin + vHeight * yNorthEast);
            t.func_78381_a();
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(0.5, -0.5, 0.5, uMin, vMin);
            t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMin, vMin + vHeight * ySouthEast);
            t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMax, vMin + vHeight * ySouthWest);
            t.func_78374_a(-0.5, -0.5, 0.5, uMax, vMin);
            t.func_78381_a();
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(0.5, -0.5, -0.5, uMin, vMin);
            t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMin, vMin + vHeight * yNorthEast);
            t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMax, vMin + vHeight * ySouthEast);
            t.func_78374_a(0.5, -0.5, 0.5, uMax, vMin);
            t.func_78381_a();
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(-0.5, -0.5, 0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMin, vMin + vHeight * ySouthWest);
            t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMax, vMin + vHeight * yNorthWest);
            t.func_78374_a(-0.5, -0.5, -0.5, uMax, vMin);
            t.func_78381_a();
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(0.5, -0.5 + ySouthEast, 0.5, uMax, vMin);
            t.func_78374_a(0.5, -0.5 + yNorthEast, -0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5 + yNorthWest, -0.5, uMin, vMax);
            t.func_78374_a(-0.5, -0.5 + ySouthWest, 0.5, uMax, vMax);
            t.func_78381_a();
            t.func_78382_b();
            t.func_78386_a(r, g, b);
            t.func_78374_a(0.5, -0.5, -0.5, uMax, vMin);
            t.func_78374_a(0.5, -0.5, 0.5, uMin, vMin);
            t.func_78374_a(-0.5, -0.5, 0.5, uMin, vMax);
            t.func_78374_a(-0.5, -0.5, -0.5, uMax, vMax);
            t.func_78381_a();
            GL11.glEnable((int)2896);
            GL11.glPopMatrix();
        }
    }
}

