/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.schematic;

import java.util.HashMap;
import java.util.Map;
import resonant.lib.schematic.Placement;
import universalelectricity.core.transform.AbstractOperation;
import universalelectricity.core.transform.vector.Vector3;
import universalelectricity.core.transform.vector.VectorWorld;

public class BuildMap {
    private Vector3[] coords;
    private Placement[] blocks;
    private int lastBlockPos = 0;

    public BuildMap(int size) {
        this.coords = new Vector3[size];
        this.blocks = new Placement[size];
    }

    public BuildMap(HashMap<Vector3, Placement> map) {
        this(map.size());
        int p = 0;
        for (Map.Entry<Vector3, Placement> entry : map.entrySet()) {
            this.coords[p] = entry.getKey();
            this.blocks[p] = entry.getValue();
            ++p;
        }
    }

    public void build(VectorWorld spot) {
        this.build(spot, this.coords.length - this.lastBlockPos);
    }

    public void build(VectorWorld spot, int numberOfBlocks) {
        for (int i = 0; i < numberOfBlocks; ++i) {
            this.blocks[this.lastBlockPos + i].place((VectorWorld)this.coords[i].clone().add((AbstractOperation)spot));
        }
        this.lastBlockPos += numberOfBlocks;
    }

    public void add(int p, Vector3 key, Placement placement) {
        this.coords[p] = key;
        this.blocks[p] = placement;
    }
}

