/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.schematic;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraftforge.common.util.ForgeDirection;
import resonant.lib.schematic.BuildMap;
import resonant.lib.schematic.Placement;
import resonant.lib.type.Pair;
import universalelectricity.core.transform.AbstractOperation;
import universalelectricity.core.transform.vector.Vector3;

public abstract class Schematic {
    public abstract String getName();

    public BuildMap getBuildMap(Vector3 center, ForgeDirection facingDirection, int size) {
        HashMap<Vector3, Pair<Block, Integer>> map = this.getStructure(facingDirection, size);
        BuildMap buildMap = new BuildMap(map.size());
        int p = 0;
        for (Map.Entry<Vector3, Pair<Block, Integer>> entry : map.entrySet()) {
            buildMap.add(p, entry.getKey(), new Placement(entry.getValue().left(), entry.getValue().right()));
            ++p;
        }
        return buildMap;
    }

    public abstract HashMap<Vector3, Pair<Block, Integer>> getStructure(ForgeDirection var1, int var2);

    public HashMap<Vector3, Pair<Block, Integer>> getLine(Vector3 start, ForgeDirection dir, Block block, int meta, int length) {
        HashMap<Vector3, Pair<Block, Integer>> returnMap = new HashMap<Vector3, Pair<Block, Integer>>();
        for (int i = 0; i < length; ++i) {
            returnMap.put((Vector3)((Vector3)new Vector3(dir).multiply((double)i)).add((AbstractOperation)start), new Pair<Block, Integer>(block, meta));
        }
        return returnMap;
    }

    public HashMap<Vector3, Pair<Block, Integer>> getBox(Vector3 center, Block block, int meta, int size) {
        return this.getBox(center, block, meta, size, size);
    }

    public HashMap<Vector3, Pair<Block, Integer>> getBox(Vector3 center, Block block, int meta, int sizeX, int sizeZ) {
        HashMap<Vector3, Pair<Block, Integer>> returnMap = new HashMap<Vector3, Pair<Block, Integer>>();
        Vector3 start = (Vector3)new Vector3((double)(-sizeX), 0.0, (double)(-sizeZ)).add((AbstractOperation)center);
        if (sizeX != sizeZ) {
            for (int x = 0; x <= sizeX * 2; ++x) {
                returnMap.put((Vector3)new Vector3((double)x, 0.0, 0.0).add((AbstractOperation)start), new Pair<Block, Integer>(block, meta));
                returnMap.put((Vector3)new Vector3((double)x, 0.0, (double)(sizeZ * 2)).add((AbstractOperation)start), new Pair<Block, Integer>(block, meta));
            }
            for (int z = 0; z <= sizeZ * 2; ++z) {
                returnMap.put((Vector3)new Vector3(0.0, 0.0, (double)z).add((AbstractOperation)start), new Pair<Block, Integer>(block, meta));
                returnMap.put((Vector3)new Vector3((double)(sizeX * 2), 0.0, (double)z).add((AbstractOperation)start), new Pair<Block, Integer>(block, meta));
            }
        } else {
            for (int s = 0; s <= sizeX * 2; ++s) {
                returnMap.put((Vector3)new Vector3((double)s, 0.0, 0.0).add((AbstractOperation)start), new Pair<Block, Integer>(block, meta));
                returnMap.put((Vector3)new Vector3((double)s, 0.0, (double)(sizeZ * 2)).add((AbstractOperation)start), new Pair<Block, Integer>(block, meta));
                returnMap.put((Vector3)new Vector3(0.0, 0.0, (double)s).add((AbstractOperation)start), new Pair<Block, Integer>(block, meta));
                returnMap.put((Vector3)new Vector3((double)(sizeZ * 2), 0.0, (double)s).add((AbstractOperation)start), new Pair<Block, Integer>(block, meta));
            }
        }
        return returnMap;
    }
}

