/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.science.units;

public enum MetricUnit {
    MICRO("Micro", "u", 1.0E-6f),
    MILLI("Milli", "m", 0.001f),
    BASE("", "", 1.0f),
    KILO("Kilo", "k", 1000.0f),
    MEGA("Mega", "M", 1000000.0f),
    GIGA("Giga", "G", 1.0E9f),
    TERA("Tera", "T", 1.0E12f),
    PETA("Peta", "P", 1.0E15f),
    EXA("Exa", "E", 1.0E18f),
    ZETTA("Zetta", "Z", 1.0E21f),
    YOTTA("Yotta", "Y", 1.0E24f);

    public String name;
    public String symbol;
    public float value;

    private MetricUnit(String name, String symbol, float value) {
        this.name = name;
        this.symbol = symbol;
        this.value = value;
    }

    public static float convert(MetricUnit a, MetricUnit b, float value) {
        value *= a.value;
        return value /= b.value;
    }

    public static String applyUnits(float value, int decimalPlaces, float multiplier) {
        String prefix = "";
        if (value < 0.0f) {
            value = Math.abs(value);
            prefix = "-";
        }
        if ((value *= multiplier) == 0.0f) {
            return value + " ";
        }
        for (int i = 0; i < MetricUnit.values().length; ++i) {
            MetricUnit lowerMeasure = MetricUnit.values()[i];
            if (lowerMeasure.isBellow(value) && lowerMeasure.ordinal() == 0) {
                return prefix + MetricUnit.roundDecimals(lowerMeasure.process(value), decimalPlaces);
            }
            if (lowerMeasure.ordinal() + 1 >= MetricUnit.values().length) {
                return prefix + MetricUnit.roundDecimals(lowerMeasure.process(value), decimalPlaces);
            }
            MetricUnit upperMeasure = MetricUnit.values()[i + 1];
            if ((!lowerMeasure.isAbove(value) || !upperMeasure.isBellow(value)) && lowerMeasure.value != value) continue;
            return prefix + MetricUnit.roundDecimals(lowerMeasure.process(value), decimalPlaces);
        }
        return prefix + MetricUnit.roundDecimals(value, decimalPlaces);
    }

    public static double roundDecimals(double d, int decimalPlaces) {
        int j = (int)(d * Math.pow(10.0, decimalPlaces));
        return (double)j / Math.pow(10.0, decimalPlaces);
    }

    public String getName(boolean getShort) {
        if (getShort) {
            return this.symbol;
        }
        return this.name;
    }

    public double process(double value) {
        return value / (double)this.value;
    }

    public boolean isAbove(float value) {
        return value > this.value;
    }

    public boolean isBellow(float value) {
        return value < this.value;
    }

    public float convert(MetricUnit unit, float value) {
        return MetricUnit.convert(this, unit, value);
    }
}

