/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.utility;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;
import resonant.lib.type.Pair;
import resonant.lib.utility.inventory.AutoCraftingManager;
import resonant.lib.utility.inventory.InventoryUtility;
import universalelectricity.core.transform.vector.Vector3;
import universalelectricity.core.transform.vector.VectorWorld;

public class FluidUtility {
    public static Set<Pair<Block, Integer>> replacableBlockMeta = new HashSet<Pair<Block, Integer>>();
    public static Set<Block> replacableBlocks = new HashSet<Block>();
    public static Set<Block> nonBlockDropList = new HashSet<Block>();

    public static int getFluidAmountFromBlock(World world, Vector3 vector) {
        FluidStack fluidStack = FluidUtility.getFluidStackFromBlock(world, vector);
        return fluidStack != null ? fluidStack.amount : 0;
    }

    public static FluidStack getFluidStackFromBlock(World world, Vector3 vector) {
        Block block = vector.getBlock((IBlockAccess)world);
        int meta = vector.getBlockMetadata((IBlockAccess)world);
        if (block instanceof IFluidBlock) {
            IFluidBlock fluidBlock = (IFluidBlock)block;
            return new FluidStack(fluidBlock.getFluid(), (int)(1000.0f * fluidBlock.getFilledPercentage(world, vector.xi(), vector.yi(), vector.zi())));
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            if (meta == 0) {
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
        } else if ((block == Blocks.field_150353_l || block == Blocks.field_150356_k) && meta == 0) {
            return new FluidStack(FluidRegistry.LAVA, 1000);
        }
        return null;
    }

    public static FluidTankInfo[] getTankInfo(World world, Vector3 posiiton, ForgeDirection from) {
        TileEntity tile = posiiton.getTileEntity((IBlockAccess)world);
        if (tile instanceof IFluidHandler && ((IFluidHandler)tile).getTankInfo(from) != null) {
            return ((IFluidHandler)tile).getTankInfo(from);
        }
        return new FluidTankInfo[0];
    }

    public static double getFilledPercentage(FluidTankInfo ... info) {
        int amount = 0;
        int capacity = 0;
        for (FluidTankInfo tankInfo : info) {
            if (tankInfo == null || tankInfo.fluid == null) continue;
            amount += tankInfo.fluid.amount;
            capacity += tankInfo.capacity;
        }
        if (capacity > 0) {
            return (double)amount / (double)capacity;
        }
        return 0.0;
    }

    public static double getAveragePercentageFilledForSides(Class classMask, double defaultFill, World world, Vector3 position, ForgeDirection ... sides) {
        if (defaultFill > 0.98) {
            return 1.0;
        }
        double fullness = defaultFill;
        int count = 1;
        for (ForgeDirection side : sides) {
            FluidTankInfo[] info;
            TileEntity tile = position.clone().add(side).getTileEntity((IBlockAccess)world);
            if (tile == null || classMask != null && !classMask.isAssignableFrom(tile.getClass()) || (info = FluidUtility.getTankInfo(world, position.clone().add(side), side)).length <= 0) continue;
            fullness += FluidUtility.getFilledPercentage(info);
            ++count;
        }
        return Math.max(0.0, Math.min(1.0, fullness / (double)count));
    }

    public static Fluid getFluidFromBlock(World world, Vector3 vector) {
        return FluidUtility.getFluidFromBlockID(vector.getBlock((IBlockAccess)world));
    }

    public static Fluid getFluidFromBlockID(Block block) {
        if (block instanceof IFluidBlock) {
            return ((IFluidBlock)block).getFluid();
        }
        if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
            return FluidRegistry.WATER;
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return FluidRegistry.LAVA;
        }
        return null;
    }

    public static FluidStack getStack(FluidStack stack, int amount) {
        if (stack != null) {
            FluidStack newStack = stack.copy();
            newStack.amount = amount;
            return newStack;
        }
        return stack;
    }

    public static boolean matchExact(FluidStack stack, FluidStack stack2) {
        if (stack == null && stack2 == null) {
            return true;
        }
        if (stack != null && stack.isFluidEqual(stack2)) {
            return stack.amount == stack2.amount;
        }
        return false;
    }

    public static FluidStack drainBlock(World world, Vector3 position, boolean doDrain) {
        return FluidUtility.drainBlock(world, position, doDrain, 3);
    }

    public static FluidStack drainBlock(World world, Vector3 position, boolean doDrain, int update2) {
        if (world == null || position == null) {
            return null;
        }
        Block block = position.getBlock((IBlockAccess)world);
        int meta = position.getBlockMetadata((IBlockAccess)world);
        if (block != null) {
            if (block instanceof IFluidBlock && ((IFluidBlock)block).canDrain(world, position.xi(), position.yi(), position.zi())) {
                return ((IFluidBlock)block).drain(world, position.xi(), position.yi(), position.zi(), doDrain);
            }
            if ((block == Blocks.field_150355_j || block == Blocks.field_150358_i) && position.getBlockMetadata((IBlockAccess)world) == 0) {
                if (doDrain) {
                    Vector3 vec = position.clone().add(ForgeDirection.UP);
                    if (vec.getBlock((IBlockAccess)world) == Blocks.field_150355_j) {
                        vec.setBlock(world, Blocks.field_150350_a, 0, update2);
                        position.setBlock(world, block, meta);
                    } else {
                        position.setBlock(world, Blocks.field_150350_a, 0, update2);
                    }
                }
                return new FluidStack(FluidRegistry.WATER, 1000);
            }
            if ((block == Blocks.field_150353_l || block == Blocks.field_150356_k) && position.getBlockMetadata((IBlockAccess)world) == 0) {
                if (doDrain) {
                    position.setBlock(world, Blocks.field_150350_a, 0, update2);
                }
                return new FluidStack(FluidRegistry.LAVA, 1000);
            }
        }
        return null;
    }

    public static boolean isFillableBlock(World world, Vector3 node) {
        if (world == null || node == null) {
            return false;
        }
        Block block = node.getBlock((IBlockAccess)world);
        int meta = node.getBlockMetadata((IBlockAccess)world);
        if (FluidUtility.drainBlock(world, node, false) != null) {
            return false;
        }
        if (block.isAir((IBlockAccess)world, node.xi(), node.yi(), node.zi())) {
            return true;
        }
        return !(block instanceof IFluidBlock) && !(block instanceof BlockLiquid) && block.isReplaceable((IBlockAccess)world, node.xi(), node.yi(), node.zi()) || replacableBlockMeta.contains(new Pair<Block, Integer>(block, meta)) || replacableBlocks.contains(block);
    }

    public static boolean isFillableFluid(World world, Vector3 node) {
        if (world == null || node == null) {
            return false;
        }
        Block block = node.getBlock((IBlockAccess)world);
        int meta = node.getBlockMetadata((IBlockAccess)world);
        if (FluidUtility.drainBlock(world, node, false) != null) {
            return false;
        }
        if (block instanceof IFluidBlock || block instanceof BlockLiquid) {
            return meta != 0;
        }
        return false;
    }

    public static int fillBlock(World world, Vector3 node, FluidStack stack, boolean doFill) {
        if ((FluidUtility.isFillableBlock(world, node) || FluidUtility.isFillableFluid(world, node)) && stack != null && stack.amount >= 1000) {
            if (doFill) {
                Block block = node.getBlock((IBlockAccess)world);
                int meta = node.getBlockMetadata((IBlockAccess)world);
                Vector3 vec = node.clone().add(ForgeDirection.UP);
                if (block != null) {
                    if (block == Blocks.field_150355_j && vec.getBlock((IBlockAccess)world).isAir((IBlockAccess)world, node.xi(), node.yi(), node.zi())) {
                        vec.setBlock(world, block, meta);
                    } else if (block != null && replacableBlocks.contains(block) && !nonBlockDropList.contains(block)) {
                        block.func_149697_b(world, node.xi(), node.yi(), node.zi(), meta, 1);
                        block.func_149749_a(world, node.xi(), node.yi(), node.zi(), block, meta);
                    }
                }
                node.setBlock(world, stack.getFluid().getBlock());
            }
            return 1000;
        }
        return 0;
    }

    public static int fillTanksAllSides(World world, Vector3 origin, FluidStack stack, boolean doFill, ForgeDirection ... ignore) {
        int filled = 0;
        FluidStack fillStack = stack != null ? stack.copy() : null;
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (fillStack == null || fillStack.amount <= 0) {
                return filled;
            }
            if (ignore != null) {
                for (int i = 0; i < ignore.length; ++i) {
                    if (direction != ignore[i]) continue;
                }
            }
            fillStack = FluidUtility.getStack(stack, stack.amount - (filled += FluidUtility.fillTankSide(world, origin, stack, doFill, direction)));
        }
        return filled;
    }

    public static int fillTankSide(World world, Vector3 origin, FluidStack stack, boolean doFill, ForgeDirection direction) {
        TileEntity entity = origin.clone().add(direction).getTileEntity((IBlockAccess)world);
        if (entity instanceof IFluidHandler && ((IFluidHandler)entity).canFill(direction.getOpposite(), stack.getFluid())) {
            return ((IFluidHandler)entity).fill(direction.getOpposite(), stack, doFill);
        }
        return 0;
    }

    public static int fillAllTanks(List<IFluidTank> tanks, FluidStack resource, boolean doFill) {
        int totalFilled = 0;
        FluidStack fill = resource.copy();
        for (IFluidTank tank : tanks) {
            if (fill.amount <= 0) break;
            int filled = tank.fill(fill, doFill);
            totalFilled += filled;
            fill.amount -= filled;
        }
        return totalFilled;
    }

    public static FluidStack drainAllTanks(List<IFluidTank> tanks, int amount, boolean doDrain) {
        FluidStack drain = null;
        for (IFluidTank tank : tanks) {
            if (drain != null && drain.amount >= amount) break;
            FluidStack drained = tank.drain(amount, false);
            if (drained == null) continue;
            if (drain == null) {
                drain = drained;
                tank.drain(amount, doDrain);
                continue;
            }
            if (!drain.equals((Object)drained)) continue;
            drain.amount += drained.amount;
            tank.drain(amount, doDrain);
        }
        return drain;
    }

    public static boolean playerActivatedFluidItem(World world, int x, int y, int z, EntityPlayer entityplayer, int side) {
        ItemStack current = entityplayer.field_71071_by.func_70448_g();
        if (current != null && world.func_147438_o(x, y, z) instanceof IFluidHandler) {
            FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            IFluidHandler tank = (IFluidHandler)world.func_147438_o(x, y, z);
            if (fluid != null) {
                if (tank.fill(ForgeDirection.getOrientation((int)side), fluid.copy(), false) == fluid.amount) {
                    tank.fill(ForgeDirection.getOrientation((int)side), fluid.copy(), true);
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        InventoryUtility.consumeHeldItem(entityplayer);
                    }
                    return true;
                }
            } else {
                ItemStack filled;
                FluidStack available = tank.drain(ForgeDirection.getOrientation((int)side), Integer.MAX_VALUE, false);
                if (available != null && (fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        if (!entityplayer.field_71071_by.func_70441_a(filled)) {
                            return false;
                        }
                        InventoryUtility.dropItemStack(new VectorWorld((Entity)entityplayer), filled);
                    }
                    tank.drain(ForgeDirection.UNKNOWN, fluid.amount, true);
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean playerActivatedFluidItem(List<IFluidTank> tanks, EntityPlayer entityplayer, int side) {
        ItemStack current = entityplayer.field_71071_by.func_70448_g();
        if (current != null) {
            FluidStack resource = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            if (resource != null) {
                if (FluidUtility.fillAllTanks(tanks, resource, false) >= resource.amount) {
                    FluidUtility.fillAllTanks(tanks, resource, true);
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, AutoCraftingManager.consumeItem(current, 1));
                    }
                    return true;
                }
            } else {
                ItemStack filled;
                FluidStack available = FluidUtility.drainAllTanks(tanks, Integer.MAX_VALUE, false);
                if (available != null && (resource = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                    if (!entityplayer.field_71075_bZ.field_75098_d) {
                        if (current.field_77994_a > 1) {
                            if (!entityplayer.field_71071_by.func_70441_a(filled)) {
                                return false;
                            }
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, AutoCraftingManager.consumeItem(current, 1));
                        } else {
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, AutoCraftingManager.consumeItem(current, 1));
                            entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, filled);
                        }
                    }
                    FluidUtility.drainAllTanks(tanks, resource.amount, true);
                    return true;
                }
            }
        }
        return false;
    }

    public static ItemStack drainItem(ItemStack stack, IFluidHandler tank, ForgeDirection side) {
        FluidStack liquid;
        if (stack != null && tank != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack)) != null && tank.fill(side, liquid, true) > 0) {
            return stack.func_77973_b().getContainerItem(stack);
        }
        return stack;
    }

    public static ItemStack fillItem(ItemStack stack, IFluidHandler tank, ForgeDirection side) {
        if (stack != null && tank != null) {
            ItemStack liquidItem;
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            FluidStack drainStack = tank.drain(side, Integer.MAX_VALUE, false);
            if (liquid == null && drainStack != null && tank.drain(side, FluidContainerRegistry.getFluidForFilledItem((ItemStack)(liquidItem = FluidContainerRegistry.fillFluidContainer((FluidStack)drainStack, (ItemStack)stack))), true) != null) {
                return liquidItem;
            }
        }
        return stack;
    }

    public static List<FluidStack> getFluidList(FluidTankInfo ... fluidTankInfos) {
        ArrayList<FluidStack> stackList = new ArrayList<FluidStack>();
        HashMap<FluidStack, Integer> map = new HashMap<FluidStack, Integer>();
        if (fluidTankInfos != null) {
            for (int i = 0; i < fluidTankInfos.length; ++i) {
                FluidTankInfo info = fluidTankInfos[i];
                if (info == null || info.fluid == null) continue;
                FluidStack stack = info.fluid;
                if (map.containsKey(FluidUtility.getStack(stack, 0))) {
                    map.put(FluidUtility.getStack(stack, 0), (Integer)map.get(FluidUtility.getStack(stack, 0)) + stack.amount);
                    continue;
                }
                map.put(FluidUtility.getStack(stack, 0), stack.amount);
            }
            for (Map.Entry entry : map.entrySet()) {
                stackList.add(FluidUtility.getStack((FluidStack)entry.getKey(), (Integer)entry.getValue()));
            }
        }
        return stackList;
    }

    static {
        replacableBlocks.add(Blocks.field_150464_aj);
        replacableBlocks.add((Block)Blocks.field_150330_I);
        nonBlockDropList.add((Block)Blocks.field_150330_I);
        replacableBlocks.add(Blocks.field_150392_bi);
        replacableBlocks.add((Block)Blocks.field_150337_Q);
        replacableBlocks.add((Block)Blocks.field_150338_P);
        replacableBlocks.add(Blocks.field_150388_bm);
        replacableBlocks.add(Blocks.field_150345_g);
        replacableBlocks.add(Blocks.field_150394_bc);
        nonBlockDropList.add(Blocks.field_150394_bc);
        replacableBlocks.add(Blocks.field_150393_bb);
        nonBlockDropList.add(Blocks.field_150393_bb);
        replacableBlocks.add((Block)Blocks.field_150329_H);
        replacableBlocks.add(Blocks.field_150478_aa);
    }
}

