/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.utility;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import resonant.api.IRemovable;
import resonant.engine.References;
import resonant.lib.utility.WrenchUtility;
import resonant.lib.utility.inventory.InventoryUtility;
import universalelectricity.core.transform.vector.VectorWorld;

public class PlayerInteractionHandler {
    @SubscribeEvent
    public void onPlayInteract(PlayerInteractEvent event) {
        if (!event.entityPlayer.field_70170_p.field_72995_K && event.entityPlayer != null) {
            VectorWorld vec = new VectorWorld(event.entityPlayer.field_70170_p, (double)event.x, (double)event.y, (double)event.z);
            TileEntity tile = vec.getTileEntity();
            if (event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && tile instanceof IRemovable) {
                boolean do_drop = false;
                if (tile instanceof IRemovable.ICustomRemoval) {
                    do_drop = ((IRemovable.ICustomRemoval)tile).canBeRemoved(event.entityPlayer);
                } else if (tile instanceof IRemovable.ISneakWrenchable) {
                    do_drop = event.entityPlayer.func_70093_af() && WrenchUtility.isHoldingWrench(event.entityPlayer);
                } else if (tile instanceof IRemovable.IWrenchable) {
                    do_drop = WrenchUtility.isHoldingWrench(event.entityPlayer);
                } else if (tile instanceof IRemovable.ISneakPickup) {
                    do_drop = event.entityPlayer.func_70093_af() && event.entityPlayer.func_70694_bm() == null;
                } else {
                    boolean bl = do_drop = tile instanceof IRemovable.IPickup && event.entityPlayer.func_70694_bm() == null;
                }
                if (do_drop) {
                    List<ItemStack> drops = ((IRemovable)tile).getRemovedItems(event.entityPlayer);
                    if (event.isCancelable()) {
                        event.setCanceled(true);
                    }
                    try {
                        vec.world().func_147475_p(vec.xi(), vec.yi(), vec.zi());
                        vec.setBlock(Blocks.field_150350_a);
                        if (drops != null && !drops.isEmpty()) {
                            for (ItemStack item : drops) {
                                if (!event.entityPlayer.field_71071_by.func_70441_a(item)) {
                                    InventoryUtility.dropItemStack(vec, item);
                                    continue;
                                }
                                event.entityPlayer.field_71071_by.func_70296_d();
                            }
                        }
                    }
                    catch (Exception e) {
                        References.LOGGER.error("Failed to pick up block using event system");
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

