/*
 * Decompiled with CFR 0.152.
 */
package resonant.lib.utility;

import java.awt.Color;

public final class TextUtility {

    public static enum TextFormat {
        RANDOMCHARS("\u00a7k"),
        BOLD("\u00a7l"),
        STRIKE("\u00a7m"),
        UNDERLINE("\u00a7n"),
        ITALICS("\u00a7o"),
        RESETFORMAT("\u00a7r");

        private final String formatString;

        private TextFormat(String format) {
            this.formatString = format;
        }

        public final String getFormatString() {
            return this.formatString;
        }
    }

    public static enum TextColor {
        BLACK("\u00a70", 0, 0, 0, 0),
        DARKBLUE("\u00a71", 170, 0, 0, 170),
        DARKGREEN("\u00a72", 43520, 0, 170, 0),
        DARKAQUA("\u00a73", 43690, 0, 170, 170),
        DARKRED("\u00a74", 0xAA0000, 170, 0, 0),
        PURPLE("\u00a75", 0xAA00AA, 170, 0, 170),
        GOLD("\u00a76", 0xFFAA00, 255, 170, 0),
        GREY("\u00a77", 0xAAAAAA, 170, 170, 170),
        DARKGREY("\u00a78", 0x555555, 85, 85, 85),
        INDIGO("\u00a79", 0x5555FF, 85, 85, 255),
        BRIGHTGREEN("\u00a7a", 0x55FF55, 85, 255, 85),
        AQUA("\u00a7b", 0x55FFFF, 85, 255, 255),
        RED("\u00a7c", 0xFF5555, 255, 85, 85),
        PINK("\u00a7d", 0xFF55FF, 255, 85, 255),
        YELLOW("\u00a7e", 0xFFFF55, 255, 255, 85),
        WHITE("\u00a7f", 0xFFFFFF, 255, 255, 255);

        private String colorString;
        private int hexadecimal;
        private Color colorInstance;

        private TextColor(String color, int hexadecimalColor, int red, int green, int blue) {
            this.colorString = color;
            this.hexadecimal = hexadecimalColor;
            this.colorInstance = new Color(red, green, blue);
        }

        public int getHexValue() {
            return this.hexadecimal;
        }

        public Color getColor() {
            return this.colorInstance;
        }

        public String getColorString() {
            return this.colorString;
        }

        public int[] getRGBIntArray() {
            return new int[]{this.colorInstance.getRed(), this.colorInstance.getGreen(), this.colorInstance.getBlue()};
        }
    }
}

