/*
 * Decompiled with CFR 0.152.
 */
package resonant.api.ai;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.player.EntityPlayer;

public class EntitySettings {
    public static HashMap<String, Class<? extends Entity>> entityMap = new HashMap();
    public static HashMap<Class<? extends Entity>, Boolean> grabMap = new HashMap();
    private static boolean init = false;

    public static void init() {
        if (!init) {
            init = true;
            for (Map.Entry object : EntityList.field_75626_c.entrySet()) {
                if (!(object instanceof Map.Entry)) continue;
                Object key = object.getKey();
                Object value = object.getKey();
                if (!(key instanceof Class) || !(value instanceof String)) continue;
                entityMap.put((String)value, (Class)key);
            }
        }
    }

    public static Class<? extends Entity> get(String name) {
        return entityMap.get(name);
    }

    public static boolean canGrab(String name) {
        if (entityMap.containsKey(name)) {
            return EntitySettings.canGrab(entityMap.get(name));
        }
        return true;
    }

    public static boolean canGrab(Entity entity) {
        if (entity != null) {
            if (EntitySettings.canGrab(entity.getClass())) {
                return true;
            }
            for (Map.Entry<Class<? extends Entity>, Boolean> entry : grabMap.entrySet()) {
                if (!entry.getKey().isInstance(entity)) continue;
                return entry.getValue();
            }
            return true;
        }
        return false;
    }

    public static boolean canGrab(Class<? extends Entity> clazz) {
        if (grabMap.containsKey(clazz)) {
            return grabMap.get(clazz);
        }
        for (Map.Entry<Class<? extends Entity>, Boolean> entry : grabMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue();
        }
        return true;
    }

    public static void setCanNotBeGrabbed(Class<? extends Entity> clazz) {
        grabMap.put(clazz, false);
    }

    public static void setCanBeGrabbed(Class<? extends Entity> clazz) {
        grabMap.put(clazz, true);
    }

    public static void addName(Class<? extends Entity> clazz, String name) {
        entityMap.put(name, clazz);
    }

    public static void addName(String name, Class<? extends Entity> clazz) {
        EntitySettings.addName(clazz, name);
    }

    public static List<Class<? extends Entity>> getList() {
        return null;
    }

    public static String get(Class<? extends Entity> entityToInclude) {
        for (Map.Entry<String, Class<? extends Entity>> entry : entityMap.entrySet()) {
            if (entry.getClass() == null || !entry.getClass().equals(entityToInclude)) continue;
            return entry.getKey();
        }
        return null;
    }

    static {
        EntitySettings.addName("chicken", EntityChicken.class);
        EntitySettings.addName("cow", EntityCow.class);
        EntitySettings.addName("sheep", EntitySheep.class);
        EntitySettings.addName("pig", EntityPig.class);
        EntitySettings.addName("player", EntityPlayer.class);
        EntitySettings.addName("zombie", EntityZombie.class);
        EntitySettings.addName("zomb", EntityZombie.class);
        EntitySettings.addName("skeleton", EntitySkeleton.class);
        EntitySettings.addName("skel", EntitySkeleton.class);
        EntitySettings.addName("animal", EntityAnimal.class);
        EntitySettings.addName("monster", EntityMob.class);
        EntitySettings.addName("mob", EntityMob.class);
        EntitySettings.addName("creeper", EntityCreeper.class);
        EntitySettings.addName("spider", EntitySpider.class);
        EntitySettings.addName("slime", EntitySlime.class);
        EntitySettings.addName("items", EntityItem.class);
        EntitySettings.addName("item", EntityItem.class);
        EntitySettings.addName("all", Entity.class);
        EntitySettings.addName("everything", Entity.class);
        EntitySettings.addName("boat", EntityBoat.class);
        EntitySettings.addName("cart", EntityMinecart.class);
        EntitySettings.setCanNotBeGrabbed(EntityDragon.class);
        EntitySettings.setCanNotBeGrabbed(EntityWither.class);
    }
}

