/*
 * Decompiled with CFR 0.152.
 */
package resonant.content.factory;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import resonant.content.factory.Factory;

public class FactoryHandler {
    protected HashMap<String, Factory> factories;
    private HashMap<String, List<Factory>> fileExtensions;
    private String modID;

    public FactoryHandler(String modID) {
        this.modID = modID;
        this.factories = new HashMap();
        this.fileExtensions = new HashMap();
    }

    public Object generate(String type, String objectName, Object ... data) {
        if (this.factories.containsKey(type)) {
            return this.factories.get(type).generate(this.modID, objectName, data);
        }
        return null;
    }

    public Object generate(File file) {
        if (file != null) {
            Object a;
            String extension = file.getName();
            String[] sub = extension.split(".");
            extension = sub[sub.length - 1];
            List<Factory> list = null;
            Object obj = null;
            if (this.fileExtensions.containsKey(extension)) {
                list = this.fileExtensions.get(extension);
                for (Factory factory : list) {
                    if (!factory.canGenerateFromFile(file) || (a = factory.generate(file)) == null) continue;
                    obj = a;
                    break;
                }
            }
            if (list != null) {
                list = new ArrayList<Factory>();
            }
            for (Factory factory : this.factories.values()) {
                if (!factory.canGenerateFromFile(file) || (a = factory.generate(file)) == null) continue;
                obj = a;
                list.add(factory);
                break;
            }
            this.fileExtensions.put(extension, list);
            return obj;
        }
        return null;
    }
}

