/*
 * Decompiled with CFR 0.152.
 */
package resonant.content.factory.resources;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.oredict.OreDictionary;
import resonant.content.factory.Factory;
import resonant.content.factory.FactoryHandler;
import resonant.content.factory.resources.FactoryResource;
import resonant.content.factory.resources.block.FactoryFluidMixture;
import resonant.content.factory.resources.block.FactoryFluidMolten;
import resonant.content.factory.resources.item.FactoryDust;
import resonant.content.factory.resources.item.FactoryRubble;
import resonant.engine.References;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.nbt.IVirtualObject;
import resonant.lib.utility.nbt.NBTUtility;

public class ResourceFactoryHandler
extends FactoryHandler
implements IVirtualObject {
    public final Set<String> materials = new HashSet<String>();
    public final HashMap<String, Integer> materialColorCache = new HashMap();
    public final HashMap<IIcon, Integer> iconColorCache = new HashMap();
    public final BiMap<Integer, String> materialIds = HashBiMap.create();
    public FactoryDust dustFactory = new FactoryDust(this, "ResonantEngine", "resonant:");
    public FactoryRubble rubbleFactory;
    public FactoryFluidMixture mixtureFactory;
    public FactoryFluidMolten moltenFactory;
    private boolean hasGenerated = false;
    private boolean hasLoadedIDs = false;
    private int lastSetMaterialID = 0;

    public ResourceFactoryHandler() {
        super("ResonantEngine");
        this.factories.put("dust", this.dustFactory);
        this.rubbleFactory = new FactoryRubble(this, "ResonantEngine", "resonant:");
        this.factories.put("rubble", this.rubbleFactory);
        this.moltenFactory = new FactoryFluidMolten(this, "ResonantEngine", "resonant:");
        this.factories.put("moltenMetal", this.moltenFactory);
        this.mixtureFactory = new FactoryFluidMixture(this, "ResonantEngine", "resonant:");
        this.factories.put("mixtureMetal", this.mixtureFactory);
    }

    protected void loadIdData() {
    }

    public void generateAll() {
        if (!this.hasGenerated) {
            for (String material : this.materials) {
                if (!this.materialIds.values().contains(material)) {
                    while (this.lastSetMaterialID >= 5000) {
                        if (!this.materialIds.containsKey((Object)this.lastSetMaterialID)) {
                            this.materialIds.put((Object)this.lastSetMaterialID, (Object)material);
                            break;
                        }
                        ++this.lastSetMaterialID;
                    }
                }
                for (Factory factory : this.factories.values()) {
                    if (!(factory instanceof FactoryResource)) continue;
                    factory.generate(material, new Object[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public void oreRegisterEvent(OreDictionary.OreRegisterEvent evt) {
        String oreDictName;
        String materialName;
        if (evt.Name.startsWith("ingot") && !this.materials.contains(materialName = (oreDictName = evt.Name.replace("ingot", "")).substring(0, 1).toLowerCase() + oreDictName.substring(1))) {
            References.CONFIGURATION.load();
            boolean allowMaterial = References.CONFIGURATION.get("Resource-Generator", "Enable " + oreDictName, true).getBoolean(true);
            References.CONFIGURATION.save();
            if (!allowMaterial) {
                return;
            }
            this.materials.add(materialName);
        }
    }

    public String moltenToMaterial(String fluidName) {
        return this.fluidNameToMaterial(fluidName, "molten");
    }

    public String materialNameToMolten(String fluidName) {
        return this.materialNameToFluid(fluidName, "molten");
    }

    public String mixtureToMaterial(String fluidName) {
        return this.fluidNameToMaterial(fluidName, "mixture");
    }

    public String materialNameToMixture(String fluidName) {
        return this.materialNameToFluid(fluidName, "mixture");
    }

    public String fluidNameToMaterial(String fluidName, String type) {
        return LanguageUtility.decapitalizeFirst(LanguageUtility.underscoreToCamel(fluidName).replace(type, ""));
    }

    public String materialNameToFluid(String materialName, String type) {
        return type + "_" + LanguageUtility.camelToLowerUnderscore(materialName);
    }

    public BlockFluidFinite getMixture(String name) {
        return (BlockFluidFinite)Block.field_149771_c.func_82594_a("mixture" + name);
    }

    public BlockFluidFinite getMolten(String name) {
        return (BlockFluidFinite)Block.field_149771_c.func_82594_a("molten" + LanguageUtility.capitalizeFirst(name));
    }

    public ItemStack getDust(String name) {
        return this.getDust(name, 1);
    }

    public ItemStack getDust(String name, int quantity) {
        return new ItemStack(FactoryDust.dirtDust, quantity);
    }

    public ItemStack getRefinedDust(String name, int quantity) {
        return new ItemStack(FactoryDust.dust, quantity);
    }

    public String getMaterial(ItemStack stack) {
        return NBTUtility.getNBTTagCompound(stack).func_74779_i("material");
    }

    public ItemStack setMaterial(ItemStack stack, String material) {
        NBTUtility.getNBTTagCompound(stack).func_74778_a("material", material);
        return stack;
    }

    public String getName(ItemStack itemStack) {
        return LanguageUtility.decapitalizeFirst(OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack)).replace("dirtyDust", "").replace("dust", "").replace("ore", "").replace("ingot", ""));
    }

    public int getColor(String name) {
        if (name != null && this.materialColorCache.containsKey(name)) {
            return this.materialColorCache.get(name);
        }
        return 0xFFFFFF;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void reloadTextures(TextureStitchEvent.Post e) {
        this.computeColors();
    }

    @SideOnly(value=Side.CLIENT)
    public void computeColors() {
        for (String material : this.materials) {
            boolean totalR = false;
            boolean totalG = false;
            boolean totalB = false;
            boolean colorCount = false;
            for (ItemStack ingotStack : OreDictionary.getOres((String)("ingot" + LanguageUtility.capitalizeFirst(material)))) {
                Item theIngot = ingotStack.func_77973_b();
                int color = this.getAverageColor(ingotStack);
                this.materialColorCache.put(material, color);
            }
            if (this.materialColorCache.containsKey(material)) continue;
            this.materialColorCache.put(material, 0xFFFFFF);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getAverageColor(ItemStack itemStack) {
        int totalR = 0;
        int totalG = 0;
        int totalB = 0;
        int colorCount = 0;
        Item item = itemStack.func_77973_b();
        try {
            IIcon icon = item.func_77650_f(itemStack);
            if (this.iconColorCache.containsKey(icon)) {
                return this.iconColorCache.get(icon);
            }
            String iconString = icon.func_94215_i();
            if (iconString != null && !iconString.contains("MISSING_ICON_ITEM")) {
                iconString = iconString.contains(":") ? iconString.replace(":", ":textures/items/") : "textures/items/" + iconString + ".png";
                ResourceLocation textureLocation = new ResourceLocation(iconString);
                InputStream inputStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(textureLocation).func_110527_b();
                BufferedImage bufferedImage = ImageIO.read(inputStream);
                int width = bufferedImage.getWidth();
                int height = bufferedImage.getWidth();
                for (int x = 0; x < width; ++x) {
                    for (int y = 0; y < height; ++y) {
                        Color rgb = new Color(bufferedImage.getRGB(x, y));
                        double luma = 0.2126 * (double)rgb.getRed() + 0.7152 * (double)rgb.getGreen() + 0.0722 * (double)rgb.getBlue();
                        if (!(luma > 40.0)) continue;
                        totalR += rgb.getRed();
                        totalG += rgb.getGreen();
                        totalB += rgb.getBlue();
                        ++colorCount;
                    }
                }
            }
            if (colorCount > 0) {
                int averageColor = new Color(totalR /= colorCount, totalG /= colorCount, totalB /= colorCount).brighter().getRGB();
                this.iconColorCache.put(icon, averageColor);
                return averageColor;
            }
        }
        catch (Exception e) {
            System.out.println("Resonant Engine: Failed to compute colors for: " + item);
            e.printStackTrace();
        }
        return 0xFFFFFF;
    }

    @Override
    public File getSaveFile() {
        return new File(NBTUtility.getSaveDirectory(), "ResourceFactory");
    }

    @Override
    public void setSaveFile(File file) {
    }

    @Override
    public void save(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (Map.Entry entry : this.materialIds.entrySet()) {
        }
    }

    @Override
    public void load(NBTTagCompound nbt) {
    }
}

