/*
 * Decompiled with CFR 0.152.
 */
package resonant.content.factory.resources.block;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.BlockFluidFinite;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import resonant.api.recipe.MachineRecipes;
import resonant.content.factory.resources.FactoryResource;
import resonant.content.factory.resources.RecipeType;
import resonant.content.factory.resources.ResourceFactoryHandler;
import resonant.content.factory.resources.block.BlockFluidMaterial;
import resonant.lib.prefab.block.FluidColored;
import resonant.lib.render.RenderUtility;
import resonant.lib.utility.LanguageUtility;

public class FactoryFluidMolten
extends FactoryResource {
    public final HashMap<Integer, BlockFluidFinite> blockMoltenFluids = new HashMap();

    public FactoryFluidMolten(ResourceFactoryHandler gen, String modID, String prefix) {
        super(gen, modID, prefix);
    }

    public BlockFluidMaterial generate(String materialName, Object ... data) {
        String moltenName = "molten_" + materialName;
        Fluid fluidMolten = new FluidColored(moltenName).setDensity(7).setViscosity(5000).setTemperature(1811);
        if (FluidRegistry.registerFluid((Fluid)fluidMolten)) {
            fluidMolten = FluidRegistry.getFluid((String)moltenName);
        }
        BlockFluidMaterial blockFluidMaterial = new BlockFluidMaterial(fluidMolten);
        blockFluidMaterial.func_149663_c(this.prefix + "molten" + LanguageUtility.capitalizeFirst(materialName));
        GameRegistry.registerBlock((Block)blockFluidMaterial, (String)("molten" + LanguageUtility.capitalizeFirst(materialName)));
        MachineRecipes.INSTANCE.addRecipe(RecipeType.SMELTER.name(), new FluidStack(fluidMolten, 1000), "ingot" + LanguageUtility.capitalizeFirst(materialName));
        MachineRecipes.INSTANCE.addRecipe(RecipeType.SMELTER.name(), new FluidStack(fluidMolten, 1000), "dust" + LanguageUtility.capitalizeFirst(materialName));
        return blockFluidMaterial;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void postTextureHook(TextureStitchEvent.Post event) {
        for (BlockFluidFinite block : this.blockMoltenFluids.values()) {
            block.getFluid().setIcons(RenderUtility.getIcon(this.prefix + "molten_flow"));
            ((FluidColored)block.getFluid()).setColor(this.gen.getColor(this.gen.moltenToMaterial(block.getFluid().getName())));
        }
    }
}

