/*
 * Decompiled with CFR 0.152.
 */
package resonant.content.prefab.java;

import io.netty.buffer.ByteBuf;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import resonant.api.ISave;
import resonant.api.grid.INode;
import resonant.api.grid.INodeProvider;
import resonant.api.grid.IUpdate;
import resonant.content.prefab.java.TileAdvanced;
import resonant.lib.network.discriminator.PacketNode;
import resonant.lib.network.discriminator.PacketType;
import resonant.lib.network.handle.IPacketIDReceiver;

public class TileNode
extends TileAdvanced
implements INodeProvider,
IPacketIDReceiver {
    private static final Map<Class<? extends TileNode>, List<Field>> nodeFields = new LinkedHashMap<Class<? extends TileNode>, List<Field>>();
    INode baseNode = null;

    public TileNode(Material material) {
        super(material);
        this.generateNodeList();
    }

    @Override
    public void onNeighborChanged(Block block) {
        super.onNeighborChanged(block);
        this.reconstructNode();
    }

    @Override
    public void onAdded() {
        super.onAdded();
        this.reconstructNode();
    }

    private void reconstructNode() {
        for (INode node : this.getNodes()) {
            if (node == null) continue;
            node.reconstruct();
        }
    }

    @Override
    public void start() {
        super.start();
        this.reconstructNode();
    }

    @Override
    public void update() {
        super.update();
        for (INode node : this.getNodes()) {
            if (!(node instanceof IUpdate) || !((IUpdate)((Object)node)).canUpdate()) continue;
            ((IUpdate)((Object)node)).update(20.0);
        }
    }

    public void func_145843_s() {
        for (INode node : this.getNodes()) {
            if (node == null) continue;
            node.deconstruct();
        }
        super.func_145843_s();
    }

    @Override
    public INode getNode(Class<? extends INode> nodeType, ForgeDirection from) {
        return this.baseNode;
    }

    public void generateNodeList() {
        if (!nodeFields.containsKey(this.getClass())) {
            Class<?> clazz = this.getClass();
            LinkedList<Field> fields = new LinkedList<Field>();
            LinkedList<Field> allFields = new LinkedList<Field>();
            allFields.addAll(Arrays.asList(clazz.getFields()));
            allFields.addAll(Arrays.asList(clazz.getDeclaredFields()));
            for (Field field : allFields) {
                if (fields.contains(field) || !INode.class.isAssignableFrom(field.getType())) continue;
                fields.add(field);
            }
            nodeFields.put(clazz, fields);
        }
    }

    protected List<INode> getNodes() {
        LinkedList<INode> nodes = new LinkedList<INode>();
        this.getNodes(nodes);
        return nodes;
    }

    public void getNodes(List<INode> nodes) {
        if (nodeFields.containsKey(this.getClass())) {
            List<Field> fields = nodeFields.get(this.getClass());
            for (Field field : fields) {
                Object node = null;
                try {
                    field.setAccessible(true);
                    Object object = field.get(this);
                    if (!(object instanceof INode)) continue;
                    nodes.add((INode)node);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (INode node : this.getNodes()) {
            if (!(node instanceof ISave)) continue;
            ((ISave)((Object)node)).load(nbt);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (INode node : this.getNodes()) {
            if (!(node instanceof ISave)) continue;
            ((ISave)((Object)node)).save(nbt);
        }
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (type instanceof PacketNode && nodeFields.containsKey(this.getClass())) {
            for (INode node : this.getNodes()) {
                if (!((PacketNode)type).nodeClassName.equalsIgnoreCase("INode") && !node.getClass().getSimpleName().equalsIgnoreCase(((PacketNode)type).nodeClassName) || !(node instanceof IPacketIDReceiver) || !((IPacketIDReceiver)((Object)node)).read(buf, id, player, type)) continue;
                return true;
            }
        }
        return false;
    }
}

