/*
 * Decompiled with CFR 0.152.
 */
package resonant.engine.asm;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import resonant.lib.asm.ASMHelper;
import resonant.lib.asm.ObfMapping;

public class Transformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (transformedName.equals("net.minecraft.world.chunk.Chunk")) {
            System.out.println("[Resonant-Engine] Transforming Chunk class for chunkModified event.");
            ClassNode cnode = ASMHelper.createClassNode(bytes);
            for (MethodNode method : cnode.methods) {
                ObfMapping m = new ObfMapping(cnode.name, method.name, method.desc).toRuntime();
                if (!m.s_name.equals("func_150807_a") && !m.s_name.equals("func_150807_a")) continue;
                System.out.println("[Resonant-Engine] Found method " + m.s_name);
                InsnList list = new InsnList();
                list.add((AbstractInsnNode)new VarInsnNode(25, 0));
                list.add((AbstractInsnNode)new VarInsnNode(21, 1));
                list.add((AbstractInsnNode)new VarInsnNode(21, 2));
                list.add((AbstractInsnNode)new VarInsnNode(21, 3));
                list.add((AbstractInsnNode)new VarInsnNode(25, 4));
                list.add((AbstractInsnNode)new VarInsnNode(21, 5));
                list.add((AbstractInsnNode)new MethodInsnNode(184, "resonant/engine/asm/StaticForwarder", "chunkSetBlockEvent", "(Lnet/minecraft/world/chunk/Chunk;IIILnet/minecraft/block/Block;I)V"));
                AbstractInsnNode lastInsn = method.instructions.getLast();
                while (lastInsn instanceof LabelNode || lastInsn instanceof LineNumberNode) {
                    lastInsn = lastInsn.getPrevious();
                }
                if (this.isReturn(lastInsn)) {
                    method.instructions.insertBefore(lastInsn, list);
                } else {
                    method.instructions.insert(list);
                }
                System.out.println("[Resonant-Engine] Injected instruction to method: " + m.s_name);
            }
            return ASMHelper.createBytes(cnode, 0);
        }
        return bytes;
    }

    private boolean isReturn(AbstractInsnNode node) {
        switch (node.getOpcode()) {
            case 169: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }
}

