/*
 * Decompiled with CFR 0.152.
 */
package resonant.engine.grid.frequency;

import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import resonant.api.blocks.IBlockFrequency;
import resonant.api.mffs.fortron.FrequencyGridRegistry;
import resonant.lib.grid.Grid;
import resonant.lib.transform.region.Cuboid;
import resonant.lib.transform.vector.Vector3;
import scala.Function1;
import scala.Serializable;
import scala.collection.convert.WrapAsScala;
import scala.collection.convert.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Md\u0001B\u0001\u0003\u0001-\u0011QB\u0012:fcV,gnY=He&$'BA\u0002\u0005\u0003%1'/Z9vK:\u001c\u0017P\u0003\u0002\u0006\r\u0005!qM]5e\u0015\t9\u0001\"\u0001\u0004f]\u001eLg.\u001a\u0006\u0002\u0013\u0005A!/Z:p]\u0006tGo\u0001\u0001\u0014\u0007\u0001a1\u0004E\u0002\u000e#Mi\u0011A\u0004\u0006\u0003\u000b=Q!\u0001\u0005\u0005\u0002\u00071L'-\u0003\u0002\u0013\u001d\t!qI]5e!\t!\u0012$D\u0001\u0016\u0015\t1r#\u0001\u0004cY>\u001c7n\u001d\u0006\u00031!\t1!\u00199j\u0013\tQRCA\bJ\u00052|7m\u001b$sKF,XM\\2z!\taBE\u0004\u0002\u001eE5\taD\u0003\u0002 A\u00059am\u001c:ue>t'BA\u0011\u0018\u0003\u0011igMZ:\n\u0005\rr\u0012!\u0006$sKF,XM\\2z\u000fJLGMU3hSN$(/_\u0005\u0003K\u0019\u0012a\"\u0013$sKF,XM\\2z\u000fJLGM\u0003\u0002$=!)\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"\u0012A\u000b\t\u0003W\u0001i\u0011A\u0001\u0005\u0006[\u0001!\tEL\u0001\u0004C\u0012$GCA\u00186!\t\u00014'D\u00012\u0015\u0005\u0011\u0014!B:dC2\f\u0017B\u0001\u001b2\u0005\u0011)f.\u001b;\t\u000bYb\u0003\u0019A\n\u0002\t9|G-\u001a\u0005\u0006q\u0001!\t%O\u0001\u0007e\u0016lwN^3\u0015\u0005=R\u0004\"\u0002\u001c8\u0001\u0004\u0019\u0002\"\u0002\u001f\u0001\t\u0003i\u0014\u0001C4fi:{G-Z:\u0016\u0005yJEcA P1B\u0019\u0001)R$\u000e\u0003\u0005S!AQ\"\u0002\tU$\u0018\u000e\u001c\u0006\u0002\t\u0006!!.\u0019<b\u0013\t1\u0015IA\u0002TKR\u0004\"\u0001S%\r\u0001\u0011)!j\u000fb\u0001\u0017\n\t1)\u0005\u0002M'A\u0011\u0001'T\u0005\u0003\u001dF\u0012qAT8uQ&tw\rC\u0003Qw\u0001\u0007\u0011+A\u0003dY\u0006T(\u0010E\u0002S+\u001es!\u0001M*\n\u0005Q\u000b\u0014A\u0002)sK\u0012,g-\u0003\u0002W/\n)1\t\\1tg*\u0011A+\r\u0005\u00063n\u0002\rAW\u0001\u0002aB!\u0001gW$^\u0013\ta\u0016GA\u0005Gk:\u001cG/[8ocA\u0011\u0001GX\u0005\u0003?F\u0012qAQ8pY\u0016\fg\u000eC\u0003=\u0001\u0011\u0005\u0013-\u0006\u0002cKR\u00111M\u001a\t\u0004\u0001\u0016#\u0007C\u0001%f\t\u0015Q\u0005M1\u0001L\u0011\u0015\u0001\u0006\r1\u0001h!\r\u0011V\u000b\u001a\u0005\u0006y\u0001!\t%\u001b\u000b\u0003U.\u00042\u0001Q#\u0014\u0011\u0015\u0019\u0001\u000e1\u0001m!\t\u0001T.\u0003\u0002oc\t\u0019\u0011J\u001c;\t\u000bq\u0002A\u0011\t9\u0016\u0005E$Hc\u0001:voB\u0019\u0001)R:\u0011\u0005!#H!\u0002&p\u0005\u0004Y\u0005\"\u0002)p\u0001\u00041\bc\u0001*Vg\")1a\u001ca\u0001Y\")A\b\u0001C!sRA!N_A\u0006\u0003?\t\u0019\u0003C\u0003|q\u0002\u0007A0A\u0003x_JdG\rE\u0002~\u0003\u000fi\u0011A \u0006\u0003w~TA!!\u0001\u0002\u0004\u0005IQ.\u001b8fGJ\fg\r\u001e\u0006\u0003\u0003\u000b\t1A\\3u\u0013\r\tIA \u0002\u0006/>\u0014H\u000e\u001a\u0005\b\u0003\u001bA\b\u0019AA\b\u0003!\u0001xn]5uS>t\u0007\u0003BA\t\u00037i!!a\u0005\u000b\t\u0005U\u0011qC\u0001\u0007m\u0016\u001cGo\u001c:\u000b\u0007\u0005eq\"A\u0005ue\u0006t7OZ8s[&!\u0011QDA\n\u0005\u001d1Vm\u0019;peNBa!!\ty\u0001\u0004a\u0017A\u0002:bI&,8\u000fC\u0003\u0004q\u0002\u0007A\u000e\u0003\u0004=\u0001\u0011\u0005\u0013qE\u000b\u0005\u0003S\ty\u0003\u0006\u0007\u0002,\u0005E\u0012QGA\u001c\u0003s\tY\u0004\u0005\u0003A\u000b\u00065\u0002c\u0001%\u00020\u00111!*!\nC\u0002-Cq\u0001UA\u0013\u0001\u0004\t\u0019\u0004\u0005\u0003S+\u00065\u0002BB>\u0002&\u0001\u0007A\u0010\u0003\u0005\u0002\u000e\u0005\u0015\u0002\u0019AA\b\u0011\u001d\t\t#!\nA\u00021DaaAA\u0013\u0001\u0004a\u0007B\u0002\u001f\u0001\t\u0003\ny\u0004F\u0004k\u0003\u0003\n\u0019%a\u0015\t\rm\fi\u00041\u0001}\u0011!\t)%!\u0010A\u0002\u0005\u001d\u0013AB2vE>LG\r\u0005\u0003\u0002J\u0005=SBAA&\u0015\u0011\ti%a\u0006\u0002\rI,w-[8o\u0013\u0011\t\t&a\u0013\u0003\r\r+(m\\5e\u0011\u0019\u0019\u0011Q\ba\u0001Y\"1A\b\u0001C!\u0003/*B!!\u0017\u0002`QQ\u00111LA1\u0003K\n9'!\u001b\u0011\t\u0001+\u0015Q\f\t\u0004\u0011\u0006}CA\u0002&\u0002V\t\u00071\nC\u0004Q\u0003+\u0002\r!a\u0019\u0011\tI+\u0016Q\f\u0005\u0007w\u0006U\u0003\u0019\u0001?\t\u0011\u0005\u0015\u0013Q\u000ba\u0001\u0003\u000fBaaAA+\u0001\u0004a\u0007B\u0002\u001f\u0001\t\u0003\ti\u0007F\u0002k\u0003_Bq!WA6\u0001\u0004\t\t\b\u0005\u000317Ni\u0006")
public class FrequencyGrid
extends Grid<IBlockFrequency>
implements FrequencyGridRegistry.IFrequencyGrid {
    @Override
    public void add(IBlockFrequency node) {
        Set set = this.getNodes();
        synchronized (set) {
            super.add(node);
            return;
        }
    }

    @Override
    public void remove(IBlockFrequency node) {
        Set set = this.getNodes();
        synchronized (set) {
            super.remove(node);
            return;
        }
    }

    public <C extends IBlockFrequency> Set<C> getNodes(Class<C> clazz, Function1<C, Object> p) {
        return this.getNodes((Function1<IBlockFrequency, Object>)new Serializable(this, clazz, p){
            private final Class clazz$5;
            private final Function1 p$1;

            public final boolean apply(IBlockFrequency n) {
                return this.clazz$5.isAssignableFrom(n.getClass()) && BoxesRunTime.unboxToBoolean((Object)this.p$1.apply((Object)n));
            }
            {
                this.clazz$5 = clazz$5;
                this.p$1 = p$1;
            }
        });
    }

    @Override
    public <C extends IBlockFrequency> Set<C> getNodes(Class<C> clazz) {
        return this.getNodes((Function1<IBlockFrequency, Object>)new Serializable(this, clazz){
            private final Class clazz$4;

            public final boolean apply(IBlockFrequency n) {
                return this.clazz$4.isAssignableFrom(n.getClass());
            }
            {
                this.clazz$4 = clazz$4;
            }
        });
    }

    @Override
    public Set<IBlockFrequency> getNodes(int frequency) {
        return this.getNodes((Function1<IBlockFrequency, Object>)new Serializable(this, frequency){
            private final int frequency$6;

            public final boolean apply(IBlockFrequency x$1) {
                return x$1.getFrequency() == this.frequency$6;
            }
            {
                this.frequency$6 = frequency$6;
            }
        });
    }

    @Override
    public <C extends IBlockFrequency> Set<C> getNodes(Class<C> clazz, int frequency) {
        return this.getNodes((Function1<IBlockFrequency, Object>)new Serializable(this, clazz, frequency){
            private final Class clazz$3;
            private final int frequency$5;

            public final boolean apply(IBlockFrequency n) {
                return n.getFrequency() == this.frequency$5 && this.clazz$3.isAssignableFrom(n.getClass());
            }
            {
                this.clazz$3 = clazz$3;
                this.frequency$5 = frequency$5;
            }
        });
    }

    @Override
    public Set<IBlockFrequency> getNodes(World world, Vector3 position, int radius, int frequency) {
        return this.getNodes((Function1<IBlockFrequency, Object>)new Serializable(this, world, position, radius, frequency){
            private final World world$4;
            private final Vector3 position$2;
            private final int radius$2;
            private final int frequency$4;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(IBlockFrequency n) {
                if (n.getFrequency() != this.frequency$4) return false;
                World world = ((TileEntity)n).func_145831_w();
                World world2 = this.world$4;
                if (world == null) {
                    if (world2 != null) {
                        return false;
                    }
                } else if (!world.equals(world2)) return false;
                Vector3 vector3 = new Vector3((TileEntity)n);
                if (!(vector3.distance(this.position$2) <= (double)this.radius$2)) return false;
                return true;
            }
            {
                this.world$4 = world$4;
                this.position$2 = position$2;
                this.radius$2 = radius$2;
                this.frequency$4 = frequency$4;
            }
        });
    }

    @Override
    public <C extends IBlockFrequency> Set<C> getNodes(Class<C> clazz, World world, Vector3 position, int radius, int frequency) {
        return this.getNodes((Function1<IBlockFrequency, Object>)new Serializable(this, clazz, world, position, radius, frequency){
            private final Class clazz$2;
            private final World world$3;
            private final Vector3 position$1;
            private final int radius$1;
            private final int frequency$3;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(IBlockFrequency n) {
                if (n.getFrequency() != this.frequency$3) return false;
                if (!this.clazz$2.isAssignableFrom(n.getClass())) return false;
                World world = ((TileEntity)n).func_145831_w();
                World world2 = this.world$3;
                if (world == null) {
                    if (world2 != null) {
                        return false;
                    }
                } else if (!world.equals(world2)) return false;
                Vector3 vector3 = new Vector3((TileEntity)n);
                if (!(vector3.distance(this.position$1) <= (double)this.radius$1)) return false;
                return true;
            }
            {
                this.clazz$2 = clazz$2;
                this.world$3 = world$3;
                this.position$1 = position$1;
                this.radius$1 = radius$1;
                this.frequency$3 = frequency$3;
            }
        });
    }

    @Override
    public Set<IBlockFrequency> getNodes(World world, Cuboid cuboid, int frequency) {
        return this.getNodes((Function1<IBlockFrequency, Object>)new Serializable(this, world, cuboid, frequency){
            private final World world$2;
            private final Cuboid cuboid$2;
            private final int frequency$2;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(IBlockFrequency n) {
                if (n.getFrequency() != this.frequency$2) return false;
                World world = ((TileEntity)n).func_145831_w();
                World world2 = this.world$2;
                if (world == null) {
                    if (world2 != null) {
                        return false;
                    }
                } else if (!world.equals(world2)) return false;
                if (!this.cuboid$2.intersects(new Vector3((TileEntity)n))) return false;
                return true;
            }
            {
                this.world$2 = world$2;
                this.cuboid$2 = cuboid$2;
                this.frequency$2 = frequency$2;
            }
        });
    }

    @Override
    public <C extends IBlockFrequency> Set<C> getNodes(Class<C> clazz, World world, Cuboid cuboid, int frequency) {
        return this.getNodes((Function1<IBlockFrequency, Object>)new Serializable(this, clazz, world, cuboid, frequency){
            private final Class clazz$1;
            private final World world$1;
            private final Cuboid cuboid$1;
            private final int frequency$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(IBlockFrequency n) {
                if (n.getFrequency() != this.frequency$1) return false;
                if (!this.clazz$1.isAssignableFrom(n.getClass())) return false;
                World world = ((TileEntity)n).func_145831_w();
                World world2 = this.world$1;
                if (world == null) {
                    if (world2 != null) {
                        return false;
                    }
                } else if (!world.equals(world2)) return false;
                if (!this.cuboid$1.intersects(new Vector3((TileEntity)n))) return false;
                return true;
            }
            {
                this.clazz$1 = clazz$1;
                this.world$1 = world$1;
                this.cuboid$1 = cuboid$1;
                this.frequency$1 = frequency$1;
            }
        });
    }

    public Set<IBlockFrequency> getNodes(Function1<IBlockFrequency, Object> p) {
        return package$.MODULE$.wrapAll().mutableSetAsJavaSet((scala.collection.mutable.Set)((WrapAsScala)package$.MODULE$.wrapAll()).asScalaSet(this.getNodes()).filter(p));
    }

    public FrequencyGrid() {
        super(IBlockFrequency.class);
    }
}

