/*
 * Decompiled with CFR 0.152.
 */
package resonant.engine.grid.thermal;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import resonant.lib.transform.vector.IVector3;
import resonant.lib.transform.vector.IVectorWorld;
import resonant.lib.type.Pair;

public class HeatingDictionary {
    private static HashMap<Block, Float> blockToHeatMap = new HashMap();
    private static HashMap<Pair<Block, Integer>, Float> idMetaToHeatMap = new HashMap();
    private static HashMap<Material, Float> materialToHeatMap = new HashMap();

    public static void register(Block block, float f) {
        if (block != null && f > 0.0f) {
            blockToHeatMap.put(block, Float.valueOf(f));
        }
    }

    public static void register(Block block, int meta, float f) {
        if (block != null && f > 0.0f) {
            idMetaToHeatMap.put(new Pair<Block, Integer>(block, meta), Float.valueOf(f));
        }
    }

    public static void register(Material m, float f) {
        if (m != null && f > 0.0f) {
            materialToHeatMap.put(m, Float.valueOf(f));
        }
    }

    public static float getSpecificHeat(IVectorWorld vec) {
        return HeatingDictionary.getSpecificHeat(vec.world(), (int)vec.x(), (int)vec.y(), (int)vec.z());
    }

    public static float getSpecificHeat(World world, IVector3 vec) {
        return HeatingDictionary.getSpecificHeat(world, (int)vec.x(), (int)vec.y(), (int)vec.z());
    }

    public static float getSpecificHeat(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block != null) {
            if (blockToHeatMap.containsKey(block)) {
                return blockToHeatMap.get(block).floatValue();
            }
            if (idMetaToHeatMap.containsKey(new Pair<Block, Integer>(block, meta))) {
                return idMetaToHeatMap.get(new Pair<Block, Integer>(block, meta)).floatValue();
            }
            if (materialToHeatMap.containsKey(block.func_149688_o())) {
                return materialToHeatMap.get(block.func_149688_o()).floatValue();
            }
        }
        return 5.0f;
    }

    static {
        HeatingDictionary.register(Material.field_151573_f, 0.45f);
        HeatingDictionary.register(Material.field_151579_a, 1.0f);
        HeatingDictionary.register(Material.field_151578_c, 0.9f);
        HeatingDictionary.register(Material.field_151575_d, 0.84f);
        HeatingDictionary.register(Material.field_151576_e, 0.8f);
        HeatingDictionary.register(Material.field_151574_g, 0.5f);
        HeatingDictionary.register(Material.field_151586_h, 1.0f);
        HeatingDictionary.register(Material.field_151587_i, 0.84f);
        HeatingDictionary.register(Material.field_151584_j, 0.84f);
        HeatingDictionary.register(Material.field_151585_k, 0.84f);
        HeatingDictionary.register(Material.field_151582_l, 0.84f);
        HeatingDictionary.register(Material.field_151583_m, 0.84f);
        HeatingDictionary.register(Material.field_151580_n, 2.0f);
        HeatingDictionary.register(Material.field_151581_o, 1.0f);
        HeatingDictionary.register(Material.field_151595_p, 1.0f);
        HeatingDictionary.register(Material.field_151594_q, 1.0f);
        HeatingDictionary.register(Material.field_151593_r, 2.0f);
        HeatingDictionary.register(Material.field_151592_s, 0.84f);
        HeatingDictionary.register(Material.field_151591_t, 0.9f);
        HeatingDictionary.register(Material.field_151590_u, 2.0f);
        HeatingDictionary.register(Material.field_151589_v, 0.84f);
        HeatingDictionary.register(Material.field_151588_w, 1.0f);
        HeatingDictionary.register(Material.field_151597_y, 1.0f);
        HeatingDictionary.register(Material.field_151596_z, 1.0f);
        HeatingDictionary.register(Material.field_151570_A, 0.84f);
        HeatingDictionary.register(Material.field_151571_B, 0.92f);
        HeatingDictionary.register(Material.field_151572_C, 0.84f);
        HeatingDictionary.register(Material.field_151566_D, 0.84f);
        HeatingDictionary.register(Material.field_151567_E, 1.0f);
        HeatingDictionary.register(Material.field_151568_F, 2.0f);
        HeatingDictionary.register(Material.field_151569_G, 0.84f);
        HeatingDictionary.register(Material.field_76233_E, 0.9f);
    }
}

